/*
 * 01/09/2002 - 20:43:57
 *
 * IconBank.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary;

import javax.swing.ImageIcon;
import java.net.URL;

public class IconBank {

    //path in the jDictionary.jar
    static String path = "/" + JDictionary.getString("ResourcesDirName") + "/" + JDictionary.getString("IconPackDirName") + "/";

    static IconBank iconBank = new IconBank();
    public static ImageIcon world = new ImageIcon(iconBank.getURLForFile("World.png"));
    public static ImageIcon caution = new ImageIcon(iconBank.getURLForFile("Caution.png"));
    public static ImageIcon info = new ImageIcon(iconBank.getURLForFile("Inform.png"));
    public static ImageIcon stop = new ImageIcon(iconBank.getURLForFile("Stop.png"));
    public static ImageIcon hourGlass = new ImageIcon(iconBank.getURLForFile("HourGlass.png"));
    public static ImageIcon bulb = new ImageIcon(iconBank.getURLForFile("Bulb.png"));
    public static ImageIcon rescan = new ImageIcon(iconBank.getURLForFile("Rescan.png"));
    public static ImageIcon exit = new ImageIcon(iconBank.getURLForFile("Exit.png"));
    public static ImageIcon ThumbUp = new ImageIcon(iconBank.getURLForFile("ThumbUp.png"));
    public static ImageIcon FingerUp = new ImageIcon(iconBank.getURLForFile("FingerUp.png"));
    public static ImageIcon Folder = new ImageIcon(iconBank.getURLForFile("Folder.png"));
    public static ImageIcon FolderIn = new ImageIcon(iconBank.getURLForFile("FolderIn.png"));
    public static ImageIcon plug = new ImageIcon(iconBank.getURLForFile("Plug.png"));
    public static ImageIcon unPlug = new ImageIcon(iconBank.getURLForFile("UnPlug.png"));
    public static ImageIcon trafficGreen = new ImageIcon(iconBank.getURLForFile("TrafficGreen.png"));
    public static ImageIcon trafficRed = new ImageIcon(iconBank.getURLForFile("TrafficRed.png"));
    public static ImageIcon trafficYellow = new ImageIcon(iconBank.getURLForFile("TrafficYellow.png"));
    public static ImageIcon trafficRedYellow = new ImageIcon(iconBank.getURLForFile("TrafficRedYellow.png"));
    public static ImageIcon envelope = new ImageIcon(iconBank.getURLForFile("Envelope.png"));
    public static ImageIcon envelopeOpen = new ImageIcon(iconBank.getURLForFile("EnvelopeOpen.png"));
    public static ImageIcon laptop = new ImageIcon(iconBank.getURLForFile("Laptop.png"));
    public static ImageIcon laptopIn = new ImageIcon(iconBank.getURLForFile("LaptopIn.png"));
    public static ImageIcon hammer = new ImageIcon(iconBank.getURLForFile("Hammer.png"));


    final URL getURLForFile(String fileName) {
        return getClass().getResource(path + fileName);
    }


    public static ImageIcon getIconByName(String name) {
        return new ImageIcon(iconBank.getURLForFile(name));
    }
}