/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultTreeView.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.modules;

import info.jdictionary.JDictionary;
import info.jdictionary.gui.SheetedMutableTreeNode;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.listeners.PluginScanFinishedListener;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultTreeView extends JPanel {

    DefaultFrameAssembler assembler;
    JDictionary jDictionary;
    PluginManager pluginManager;
    DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(JDictionary.getString("Dictionaries"));
    JTree pluginTree = new JTree(rootTreeNode);
    boolean autoSelect = true;

    public DefaultTreeView(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;
        this.jDictionary = assembler.getJDictionary();
        this.pluginManager = jDictionary.getPluginManager();
        pluginTree.expandPath(new TreePath(((DefaultMutableTreeNode)((DefaultTreeModel)pluginTree.getModel()).getRoot()).getPath()));

        setBackground(Color.white);
        setLayout(new BorderLayout());
        add(pluginTree, java.awt.BorderLayout.WEST);

        pluginTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
                                                public void valueChanged(TreeSelectionEvent e) {
                                                    pluginTree_valueChanged(e);
                                                }
                                            }
                                          );

        assembler.getJDictionary().getPluginManager().addPluginStructureChangeListener(new PluginStructureChangeListener() {
                                                public void pluginAdded(PluginStructureChangeEvent e) {
                                                    pluginManager_pluginAdded(e);
                                                }
                                                public void pluginRemoved(PluginStructureChangeEvent e) {
                                                    pluginManager_pluginRemoved(e);
                                                }
                                              }
                                            );

        assembler.getJDictionary().getPluginManager().addPluginSelectionListener(new PluginSelectionListener() {
                                                public void pluginSelected(PluginSelectionEvent e) {
                                                    pluginManager_pluginSelected(e);
                                                }
                                            });

        assembler.getJDictionary().getPluginManager().addPluginScanFinishedListener(new PluginScanFinishedListener() {
                                                public void pluginScanFinished(PluginScanFinishedEvent e) {
                                                    pluginManager_pluginScanFinished(e);
                                                }
                                            });

    }


    void pluginManager_pluginAdded(final PluginStructureChangeEvent e) {
        try{
            SwingUtilities.invokeAndWait(new Runnable() {
                public void run() {
                    SheetedMutableTreeNode node = new SheetedMutableTreeNode(e.getPluginInfoSheet());
                    ((DefaultTreeModel)pluginTree.getModel()).insertNodeInto(node, rootTreeNode, 0);
                    ArrayList plugin = assembler.getJDictionary().getPluginManager().getPlugin(e.getPluginInfoSheet());
                    Iterator pluginIterator = plugin.iterator();
                    while(pluginIterator.hasNext()) {
                        DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(pluginIterator.next());
                        ((DefaultTreeModel)pluginTree.getModel()).insertNodeInto(leaf, node, 0);
                    }
                    checkExpand(node);
                    pluginTree.validate();
                    pluginTree.repaint();
                }
            });
        }
        catch(java.lang.reflect.InvocationTargetException ex) {}
        catch(java.lang.InterruptedException ex) {}
    }


    void pluginManager_pluginRemoved(final PluginStructureChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                SheetedMutableTreeNode tempNode = null;
                int n = 0;
                while (n < rootTreeNode.getChildCount()) {
                    tempNode = (SheetedMutableTreeNode) rootTreeNode.getChildAt(n);
                    if (tempNode.getInfoSheet().equals(e.getPluginInfoSheet())) {
                        ((DefaultTreeModel)pluginTree.getModel()).removeNodeFromParent(tempNode);
                        pluginTree.validate();
                        pluginTree.repaint();
                    }
                n++;
                }
            }
        });
    }


    void pluginManager_pluginScanFinished(PluginScanFinishedEvent e) {
        autoSelect = false;
    }


    void pluginManager_pluginSelected(PluginSelectionEvent e) {
        if(e.getSelectedPlugin() == null) {
            if(pluginTree.getLastSelectedPathComponent() != null)
                if(!((DefaultMutableTreeNode)pluginTree.getLastSelectedPathComponent()).isRoot())
                    pluginTree.setSelectionPath(null);
            return;
        }
        for(int i = 0; i < rootTreeNode.getChildCount(); i++) {
            SheetedMutableTreeNode node = (SheetedMutableTreeNode)rootTreeNode.getChildAt(i);
            if(e.getSelectedPlugin() == node.getInfoSheet()) {
                for(int j = 0; j < node.getChildCount(); j++) {
                    if(e.getSelectedSubPlugin() == node.getChildAt(j).toString()) {
                        TreePath path = new TreePath(((DefaultMutableTreeNode)node.getChildAt(j)).getPath());
                        pluginTree.setSelectionPath(path);
                        return;
                    }
                }
            }
        }
    }


    void pluginTree_valueChanged(TreeSelectionEvent e) {
        if(pluginTree.getSelectionCount() == 0)
            return;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)(e.getPath().getLastPathComponent());
        DefaultMutableTreeNode node = selectedNode;
        PluginInfoSheet sheet = null;
        //if root is selected
        if (selectedNode.isRoot()) {
            assembler.getOutput().showDefault();
            return;
        }
        //if the selected node is a leaf this will search its closest parent
        else
            while (node.isLeaf())
                node = (DefaultMutableTreeNode) node.getParent();

            if (node instanceof SheetedMutableTreeNode) {
                sheet = ((SheetedMutableTreeNode)node).getInfoSheet();
            }

            if (selectedNode.isLeaf()) {
                jDictionary.getPluginManager().selectPlugin(sheet, selectedNode.toString());
            }
            else {
                jDictionary.getPluginManager().selectPlugin(sheet);
            }
    }


    void checkExpand(SheetedMutableTreeNode node) {
        pluginTree.expandPath(new TreePath(rootTreeNode.getPath()));
        if (!autoSelect)
            return;
        if (jDictionary.getPrefs().lastSelectedPlugin == null) {
            assembler.getOutput().showDefault();
            autoSelect = false;
            return;
        }
        if (node.getInfoSheet().getFileName().equals(jDictionary.getPrefs().lastSelectedPlugin.getFileName())) {
            TreePath path = new TreePath(node.getPath());
            pluginTree.expandPath(path);
            for (int n = 0; n < node.getChildCount(); n++) {
                if (jDictionary.getPrefs().lastSelectedSubPluginName != null)
                    if (node.getChildAt(n).toString().equals(jDictionary.getPrefs().lastSelectedSubPluginName)) {
                        pluginTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode) node.getChildAt(n)).getPath()));
                        autoSelect = false;
                        return;
                    }
            }
            pluginTree.setSelectionPath(path);
            autoSelect = false;
            return;
        }
    }

}