/* libpasori polling func. */
#include <stdlib.h>
#include "libpasori_liblocal.h"


felica *
felica_polling(pasori* pp,uint16 systemcode,uint8 RFU,uint8 timeslot){
	felica *f;
	uint8 cmd[5];
	uint8 resp[256];
	signed int l;


	
	cmd[0]=(uint8)FELICA_CMD_POLLING; /* command code */
	cmd[1]=H8(systemcode);
	cmd[2]=L8(systemcode);
	cmd[3]=RFU; /* zero */
	cmd[4]=timeslot;

	pasori_write(pp,cmd,5);
	l = pasori_read(pp,resp,255);

	if(!l) return NULL;
	if(resp[0] != FELICA_ANS_POLLING){
		Log("!!!INVALID RETURN VALUE (%d)\n",resp[0]);
		return NULL;
	}
	f = (felica *)malloc(sizeof(felica));
	f->p = pp;
	memcpy(f->IDm,&resp[1],8);
	memcpy(f->PMm,&resp[9],8);
	f->systemcode = systemcode;

	return f;
}


