/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2019 Tobias Kortkamp <tobik@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

struct Array;
struct ArrayIterator;
struct CompareTrait;
struct diff;
struct Mempool;

struct Array *array_new(void);
struct Array *array_from_array(const void *[], size_t);
void array_append(struct Array *, const void *);
struct diff *array_diff(struct Array *, struct Array *, struct Mempool *, struct CompareTrait *);
void array_free(struct Array *);
void *array_get(struct Array *, size_t);
ssize_t array_find(struct Array *, const void *, struct CompareTrait *);
void array_insert(struct Array *, size_t, const void *);
void *array_remove(struct Array *, size_t);
void array_join(struct Array *, struct Array *[], size_t);
size_t array_len(struct Array *);
void *array_pop(struct Array *);
void array_set(struct Array *, size_t, const void *);
void array_sort(struct Array *, struct CompareTrait *);
void array_truncate(struct Array *);
void array_truncate_at(struct Array *array, size_t);

struct ArrayIterator *array_iterator(struct Array *, ssize_t, ssize_t);
void array_iterator_cleanup(struct ArrayIterator **);
bool array_iterator_next(struct ArrayIterator **, size_t *, void **, void **);

#define ARRAY_JOIN(ARRAY, ...) __ARRAY_JOIN(ARRAY, GENSYM(__array_join__), __VA_ARGS__)
#define __ARRAY_JOIN(ARRAY, ARRAYS, ...) do { \
	struct Array *ARRAYS[] = { __VA_ARGS__ }; \
	array_join(ARRAY, ARRAYS, nitems(ARRAYS)); \
} while(0);

#define ARRAY_FOREACH_SLICE(ARRAY, A, B, TYPE, VAR) \
	ITERATOR_FOREACH(Array, array, TYPE, void **, VAR, NULL, void *, void **, GENSYM(VAR), NULL, ARRAY, A, B)
#define ARRAY_FOREACH(ARRAY, TYPE, VAR) \
	ARRAY_FOREACH_SLICE(ARRAY, 0, -1, TYPE, VAR)
