//-
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2022 Tobias Kortkamp <tobik@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
#pragma once

struct Array;
struct CompareTrait;
struct Framemap;
struct FramemapIterator;
struct Mempool;

struct Framemap *framemap_new(struct CompareTrait *);
void framemap_free(struct Framemap *);

bool framemap_contains(struct Framemap *, const void *);
struct Map *framemap_flatten(struct Framemap *, struct Mempool *);
void *framemap_get(struct Framemap *, const void *);
struct Array *framemap_keys(struct Framemap *, struct Mempool *);
size_t framemap_len(struct Framemap *);
void framemap_pop(struct Framemap *);
void framemap_push(struct Framemap *);
void framemap_remove(struct Framemap *, const void *);
void framemap_remove_all(struct Framemap *, const void *);
void framemap_replace(struct Framemap *, const void *, const void *);
void framemap_truncate(struct Framemap *);
struct Array *framemap_values(struct Framemap *, struct Mempool *);

struct FramemapIterator *framemap_iterator(struct Framemap *, ssize_t, ssize_t);
void framemap_iterator_cleanup(struct FramemapIterator **);
bool framemap_iterator_next(struct FramemapIterator **, size_t *, void **, void **);

#define FRAMEMAP_FOREACH_SLICE(FRAMEMAP, A, B, KEYTYPE, KEYVAR, VALTYPE, VALVAR) \
	ITERATOR_FOREACH(Framemap, framemap, KEYTYPE, void **, KEYVAR, NULL, VALTYPE, void **, VALVAR, NULL, FRAMEMAP, A, B)
#define FRAMEMAP_FOREACH(FRAMEMAP, ...) \
	FRAMEMAP_FOREACH_SLICE(FRAMEMAP, 0, -1, __VA_ARGS__)
