/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2020 Tobias Kortkamp <tobik@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

struct Array;
struct CompareTrait;
struct Mempool;
struct Map;

struct Map *map_new(struct CompareTrait *);
void map_free(struct Map *);
void map_add(struct Map *, const void *, const void *);
void map_replace(struct Map *, const void *, const void *);
void map_remove(struct Map *, const void *);
void *map_get(struct Map *, const void *);
bool map_contains(struct Map *, const void *);
size_t map_len(struct Map *);
void map_truncate(struct Map *);
struct Array *map_keys(struct Map *, struct Mempool *);
struct Array *map_values(struct Map *, struct Mempool *);

struct MapIterator *map_iterator(struct Map *, ssize_t, ssize_t);
void map_iterator_cleanup(struct MapIterator **);
bool map_iterator_next(struct MapIterator **, size_t *, void **, void **);

#define MAP_FOREACH_SLICE(MAP, A, B, KEYTYPE, KEYVAR, VALTYPE, VALVAR) \
	ITERATOR_FOREACH(Map, map, KEYTYPE, void **, KEYVAR, NULL, VALTYPE, void **, VALVAR, NULL, MAP, A, B)
#define MAP_FOREACH(MAP, ...) \
	MAP_FOREACH_SLICE(MAP, 0, -1, __VA_ARGS__)
