/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2021 Tobias Kortkamp <tobik@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

struct CompareTrait;
struct Mempool;

struct Mempool *mempool_new(void);
void mempool_free(struct Mempool *);
void mempool_cleanup(struct Mempool **);
void mempool_inherit(struct Mempool *, struct Mempool *);
void mempool_release_all(struct Mempool *);

void *mempool_add(struct Mempool *, void *, void *);
void *mempool_alloc(struct Mempool *, size_t);
void *mempool_forget(struct Mempool *, void *);
void *mempool_move(struct Mempool *, void *, struct Mempool *);
void *mempool_release(struct Mempool *, void *);
void *mempool_take(struct Mempool *, void *);

#define mempool_array(pool) \
	mempool_add((pool), array_new(), array_free)
#define mempool_framemap(pool, cmp) \
	mempool_add((pool), framemap_new(cmp), framemap_free)
#define mempool_map(pool, cmp) \
	mempool_add((pool), map_new(cmp), map_free)
#define mempool_pool(pool) \
	mempool_add((pool), mempool_new(), mempool_free)
#define mempool_queue(pool) \
	mempool_add((pool), queue_new(), queue_free)
#define mempool_set(pool, cmp) \
	mempool_add((pool), set_new(cmp), set_free)
#define mempool_stack(pool) \
	mempool_add((pool), stack_new(), stack_free)
#define mempool_workqueue(pool, nthreads) \
	mempool_add((pool), workqueue_new((nthreads)), workqueue_free)

#define SCOPE_MEMPOOL(x) \
	struct Mempool *x __cleanup(mempool_cleanup) = mempool_new()

