/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2021 Tobias Kortkamp <tobik@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

struct Queue;

struct Queue *queue_new(void);
void queue_free(struct Queue *);
size_t queue_len(struct Queue *);
int queue_contains(struct Queue *, const void *);
void *queue_peek(struct Queue *);
void *queue_pop(struct Queue *);
void *queue_dequeue(struct Queue *);
void queue_push(struct Queue *, const void *);
void queue_truncate(struct Queue *);

struct QueueIterator *queue_iterator(struct Queue *, ssize_t, ssize_t);
void queue_iterator_cleanup(struct QueueIterator **);
int queue_iterator_next(struct QueueIterator **, size_t *, void **, void **);

#define QUEUE_FOREACH_SLICE(QUEUE, A, B, TYPE, VAR) \
	ITERATOR_FOREACH(Queue, queue, TYPE, void **, VAR, NULL, void *, void **, GENSYM(VAR), NULL, QUEUE, A, B)
#define QUEUE_FOREACH(QUEUE, TYPE, VAR) \
	QUEUE_FOREACH_SLICE(QUEUE, 0, -1, TYPE, VAR)
