/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2020 Tobias Kortkamp <tobik@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

struct Array;
struct CompareTrait;
struct Mempool;
struct Set;
struct SetIterator;

struct Set *set_new(struct CompareTrait *);
void set_free(struct Set *);
void set_add(struct Set *, const void *);
void set_remove(struct Set *, const void *);
void *set_get(struct Set *, const void *);
bool set_contains(struct Set *, const void *);
size_t set_len(struct Set *);
void set_truncate(struct Set *);
struct Array *set_values(struct Set *, struct Mempool *);

struct SetIterator *set_iterator(struct Set *, ssize_t, ssize_t);
void set_iterator_cleanup(struct SetIterator **);
bool set_iterator_next(struct SetIterator **, size_t *, void **key, void **value);

#define SET_FOREACH_SLICE(SET, A, B, TYPE, VAR) \
	ITERATOR_FOREACH(Set, set, TYPE, void **, VAR, NULL, void *, void **, GENSYM(VAR), NULL, SET, A, B)
#define SET_FOREACH(SET, TYPE, VAR) \
	SET_FOREACH_SLICE(SET, 0, -1, TYPE, VAR)
