/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.cli.Cli;
import org.sonarsource.scanner.cli.PropertyResolver;
import org.sonarsource.scanner.lib.EnvironmentConfig;

class Conf {
    private static final Logger LOG = LoggerFactory.getLogger(Conf.class);
    private static final String SCANNER_HOME = "scanner.home";
    private static final String SCANNER_SETTINGS = "scanner.settings";
    private static final String PROJECT_HOME = "project.home";
    private static final String PROJECT_SETTINGS = "project.settings";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_PROJECT_CONFIG_FILE = "sonar.projectConfigFile";
    private static final String SONAR_PROJECT_PROPERTIES_FILENAME = "sonar-project.properties";
    static final String PROPERTY_SONAR_HOST_URL = "sonar.host.url";
    private static final String BOOTSTRAP_START_TIME = "sonar.scanner.bootstrapStartTime";
    private final Cli cli;
    private final Map<String, String> env;
    private final long startTimeMs;

    Conf(Cli cli, Map<String, String> env) {
        this.cli = cli;
        this.env = env;
        this.startTimeMs = System.currentTimeMillis();
    }

    Properties properties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.loadGlobalProperties());
        result.putAll((Map<?, ?>)this.loadProjectProperties());
        result.putAll((Map<?, ?>)System.getProperties());
        result.putAll(Conf.loadEnvironmentProperties());
        result.putAll((Map<?, ?>)this.cli.properties());
        result = this.resolve(result);
        result.setProperty(PROPERTY_PROJECT_BASEDIR, Conf.getRootProjectBaseDir(result).toString());
        result.remove(PROJECT_HOME);
        result.setProperty(BOOTSTRAP_START_TIME, String.valueOf(this.startTimeMs));
        return result;
    }

    private Properties resolve(Properties props) {
        PropertyResolver resolver = new PropertyResolver(props, this.env);
        return resolver.resolve();
    }

    private static Map<String, String> loadEnvironmentProperties() {
        return EnvironmentConfig.load();
    }

    private Properties loadGlobalProperties() {
        Properties knownPropsAtThatPoint = new Properties();
        knownPropsAtThatPoint.putAll((Map<?, ?>)System.getProperties());
        knownPropsAtThatPoint.putAll(Conf.loadEnvironmentProperties());
        knownPropsAtThatPoint.putAll((Map<?, ?>)this.cli.properties());
        Path settingsFile = Conf.locatePropertiesFile(knownPropsAtThatPoint, SCANNER_HOME, "conf/sonar-scanner.properties", SCANNER_SETTINGS);
        if (settingsFile != null && Files.isRegularFile(settingsFile, new LinkOption[0])) {
            LOG.info("Scanner configuration file: {}", (Object)settingsFile);
            return Conf.toProperties(settingsFile);
        }
        LOG.info("Scanner configuration file: NONE");
        return new Properties();
    }

    private Properties loadProjectProperties() {
        Properties rootProps = new Properties();
        Properties knownPropsAtThatPoint = new Properties();
        knownPropsAtThatPoint.putAll((Map<?, ?>)System.getProperties());
        knownPropsAtThatPoint.putAll(Conf.loadEnvironmentProperties());
        knownPropsAtThatPoint.putAll((Map<?, ?>)this.cli.properties());
        Path defaultRootSettingsFile = Conf.getRootProjectBaseDir(knownPropsAtThatPoint).resolve(SONAR_PROJECT_PROPERTIES_FILENAME);
        Path rootSettingsFile = Conf.locatePropertiesFile(defaultRootSettingsFile, knownPropsAtThatPoint, PROJECT_SETTINGS);
        if (rootSettingsFile != null && Files.isRegularFile(rootSettingsFile, new LinkOption[0])) {
            LOG.info("Project root configuration file: {}", (Object)rootSettingsFile);
            rootProps.putAll((Map<?, ?>)Conf.toProperties(rootSettingsFile));
        } else {
            LOG.info("Project root configuration file: NONE");
        }
        Properties projectProps = new Properties();
        projectProps.putAll((Map<?, ?>)rootProps);
        rootProps.putAll((Map<?, ?>)knownPropsAtThatPoint);
        rootProps.setProperty(PROPERTY_PROJECT_BASEDIR, Conf.getRootProjectBaseDir(rootProps).toString());
        this.loadModulesProperties(rootProps, projectProps, "");
        return projectProps;
    }

    private static Path getRootProjectBaseDir(Properties cliProps) {
        Path absoluteProjectHome = cliProps.containsKey(PROJECT_HOME) ? Paths.get(cliProps.getProperty(PROJECT_HOME), new String[0]).toAbsolutePath() : Paths.get("", new String[0]).toAbsolutePath();
        if (!cliProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            return absoluteProjectHome;
        }
        return Conf.getAbsolutePath(cliProps.getProperty(PROPERTY_PROJECT_BASEDIR), absoluteProjectHome);
    }

    private void loadModulesProperties(Properties parentProps, Properties projectProps, String prefix) {
        Path parentBaseDir = Paths.get(parentProps.getProperty(PROPERTY_PROJECT_BASEDIR), new String[0]);
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String module : Conf.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                Properties moduleProps = Conf.extractModuleProperties(module, parentProps);
                this.loadModuleConfigFile(parentBaseDir, moduleProps, module);
                this.loadModulesProperties(moduleProps, projectProps, prefix + module + ".");
                Conf.merge(projectProps, prefix, module, moduleProps);
            }
        }
    }

    private static void merge(Properties projectProps, String prefix, String module, Properties moduleProps) {
        for (Map.Entry<Object, Object> entry : moduleProps.entrySet()) {
            projectProps.put(prefix + module + "." + entry.getKey(), entry.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadModuleConfigFile(Path parentAbsBaseDir, Properties moduleProps, String moduleId) {
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            Path absoluteBaseDir = Conf.getAbsolutePath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), parentAbsBaseDir);
            Conf.setModuleBaseDir(absoluteBaseDir, moduleProps, moduleId);
            try {
                if (Files.isSameFile(parentAbsBaseDir, absoluteBaseDir)) return;
                Conf.tryToFindAndLoadPropsFile(absoluteBaseDir, moduleProps, moduleId);
                return;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error when resolving baseDir", e);
            }
        } else if (moduleProps.containsKey(PROPERTY_PROJECT_CONFIG_FILE)) {
            this.loadModulePropsFile(parentAbsBaseDir, moduleProps, moduleId);
            moduleProps.remove(PROPERTY_PROJECT_CONFIG_FILE);
            return;
        } else {
            Path absoluteBaseDir = parentAbsBaseDir.resolve(moduleId);
            Conf.setModuleBaseDir(absoluteBaseDir, moduleProps, moduleId);
            Conf.tryToFindAndLoadPropsFile(absoluteBaseDir, moduleProps, moduleId);
        }
    }

    private static void setModuleBaseDir(Path absoluteBaseDir, Properties childProps, String moduleId) {
        if (!Files.isDirectory(absoluteBaseDir, new LinkOption[0])) {
            throw new IllegalStateException(MessageFormat.format("The base directory of the module ''{0}'' does not exist: {1}", moduleId, absoluteBaseDir));
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, absoluteBaseDir.toString());
    }

    protected static Properties extractModuleProperties(String module, Properties properties) {
        Properties moduleProps = new Properties();
        String propertyPrefix = module + ".";
        int prefixLength = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(propertyPrefix)) continue;
            moduleProps.put(key.substring(prefixLength), entry.getValue());
        }
        return moduleProps;
    }

    private static Path locatePropertiesFile(Properties props, String homeKey, String relativePathFromHome, String settingsKey) {
        Path settingsFile = null;
        String scannerHome = props.getProperty(homeKey, "");
        if (!"".equals(scannerHome)) {
            settingsFile = Paths.get(scannerHome, relativePathFromHome);
        }
        return Conf.locatePropertiesFile(settingsFile, props, settingsKey);
    }

    private static Path locatePropertiesFile(@Nullable Path defaultPath, Properties props, String settingsKey) {
        String settingsPath = props.getProperty(settingsKey, "");
        Path settingsFile = !"".equals(settingsPath) ? Paths.get(settingsPath, new String[0]) : defaultPath;
        if (settingsFile != null) {
            return settingsFile.toAbsolutePath();
        }
        return null;
    }

    private static Properties toProperties(Path file) {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream in = new FileInputStream(file.toFile());
        try {
            properties2.load(in);
            for (String propKey : properties2.stringPropertyNames()) {
                properties2.setProperty(propKey, properties2.getProperty(propKey).trim());
            }
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to load file: " + file, e);
            }
        }
        ((InputStream)in).close();
        return properties;
    }

    protected void loadModulePropsFile(Path parentAbsoluteBaseDir, Properties moduleProps, String moduleId) {
        Path propertyFile = Conf.getAbsolutePath(moduleProps.getProperty(PROPERTY_PROJECT_CONFIG_FILE), parentAbsoluteBaseDir);
        if (!Files.isRegularFile(propertyFile, new LinkOption[0])) {
            throw new IllegalStateException("The properties file of the module '" + moduleId + "' does not exist: " + propertyFile);
        }
        moduleProps.putAll((Map<?, ?>)Conf.toProperties(propertyFile));
        Path absoluteBaseDir = moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR) ? Conf.getAbsolutePath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParent()) : propertyFile.getParent();
        Conf.setModuleBaseDir(absoluteBaseDir, moduleProps, moduleId);
    }

    private static void tryToFindAndLoadPropsFile(Path absoluteBaseDir, Properties moduleProps, String moduleId) {
        Path propertyFile = absoluteBaseDir.resolve(SONAR_PROJECT_PROPERTIES_FILENAME);
        if (!Files.isRegularFile(propertyFile, new LinkOption[0])) {
            return;
        }
        moduleProps.putAll((Map<?, ?>)Conf.toProperties(propertyFile));
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            Path overwrittenBaseDir = Conf.getAbsolutePath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParent());
            Conf.setModuleBaseDir(overwrittenBaseDir, moduleProps, moduleId);
        }
    }

    protected static Path getAbsolutePath(String path, Path baseDir) {
        Path propertyFile = Paths.get(path.trim(), new String[0]);
        if (!propertyFile.isAbsolute()) {
            propertyFile = baseDir.resolve(propertyFile);
        }
        return propertyFile.normalize();
    }

    static String[] getListFromProperty(Properties properties, String key) {
        String value = properties.getProperty(key, "").trim();
        if (value.isEmpty()) {
            return new String[0];
        }
        String[] values = value.split(",");
        ArrayList<String> trimmedValues = new ArrayList<String>();
        for (String s : values) {
            String trimmedValue = s.trim();
            if (trimmedValue.isEmpty()) continue;
            trimmedValues.add(trimmedValue);
        }
        return trimmedValues.toArray(new String[0]);
    }
}

