/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.InProcessScannerEngineFacade;
import org.sonarsource.scanner.lib.NewScannerEngineFacade;
import org.sonarsource.scanner.lib.ScannerEngineFacade;
import org.sonarsource.scanner.lib.SimulationScannerEngineFacade;
import org.sonarsource.scanner.lib.System2;
import org.sonarsource.scanner.lib.internal.ArchResolver;
import org.sonarsource.scanner.lib.internal.IsolatedLauncherFactory;
import org.sonarsource.scanner.lib.internal.OsResolver;
import org.sonarsource.scanner.lib.internal.Paths2;
import org.sonarsource.scanner.lib.internal.ScannerEngineLauncher;
import org.sonarsource.scanner.lib.internal.ScannerEngineLauncherFactory;
import org.sonarsource.scanner.lib.internal.cache.FileCache;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.util.VersionUtils;

public class ScannerEngineBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineBootstrapper.class);
    private static final String SONARCLOUD_HOST = "https://sonarcloud.io";
    private static final String SONARCLOUD_REST_API = "https://api.sonarcloud.io";
    static final String SQ_VERSION_NEW_BOOTSTRAPPING = "10.6";
    private final IsolatedLauncherFactory launcherFactory;
    private final ScannerEngineLauncherFactory scannerEngineLauncherFactory;
    private final Map<String, String> bootstrapProperties = new HashMap<String, String>();
    private final ScannerHttpClient scannerHttpClient;
    private final System2 system;

    ScannerEngineBootstrapper(String app, String version, System2 system, ScannerHttpClient scannerHttpClient, IsolatedLauncherFactory launcherFactory, ScannerEngineLauncherFactory scannerEngineLauncherFactory) {
        this.system = system;
        this.scannerHttpClient = scannerHttpClient;
        this.launcherFactory = launcherFactory;
        this.scannerEngineLauncherFactory = scannerEngineLauncherFactory;
        this.setBootstrapProperty("sonar.scanner.app", app).setBootstrapProperty("sonar.scanner.appVersion", version);
    }

    public static ScannerEngineBootstrapper create(String app, String version) {
        System2 system = new System2();
        return new ScannerEngineBootstrapper(app, version, system, new ScannerHttpClient(), new IsolatedLauncherFactory(), new ScannerEngineLauncherFactory(system));
    }

    public ScannerEngineBootstrapper addBootstrapProperties(Map<String, String> p) {
        this.bootstrapProperties.putAll(p);
        return this;
    }

    public ScannerEngineBootstrapper setBootstrapProperty(String key, String value) {
        this.bootstrapProperties.put(key, value);
        return this;
    }

    public ScannerEngineFacade bootstrap() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner max available memory: {}", (Object)FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory()));
        }
        this.initBootstrapDefaultValues();
        Map<String, String> properties = Map.copyOf(this.bootstrapProperties);
        boolean isSonarCloud = this.isSonarCloud(properties);
        boolean isSimulation = properties.containsKey("sonar.scanner.internal.dumpToFile");
        Path sonarUserHome = ScannerEngineBootstrapper.resolveSonarUserHome(properties);
        FileCache fileCache = FileCache.create(sonarUserHome);
        HttpConfig httpConfig = new HttpConfig(this.bootstrapProperties, sonarUserHome);
        this.scannerHttpClient.init(httpConfig);
        String serverVersion = null;
        if (!isSonarCloud) {
            serverVersion = ScannerEngineBootstrapper.getServerVersion(this.scannerHttpClient, isSimulation, properties);
        }
        if (isSimulation) {
            return new SimulationScannerEngineFacade(properties, isSonarCloud, serverVersion);
        }
        if (isSonarCloud || VersionUtils.isAtLeastIgnoringQualifier(serverVersion, SQ_VERSION_NEW_BOOTSTRAPPING)) {
            ScannerEngineLauncher launcher = this.scannerEngineLauncherFactory.createLauncher(this.scannerHttpClient, fileCache, properties);
            return new NewScannerEngineFacade(properties, launcher, isSonarCloud, serverVersion);
        }
        IsolatedLauncherFactory.IsolatedLauncherAndClassloader launcher = this.launcherFactory.createLauncher(this.scannerHttpClient, fileCache);
        Map<String, String> adaptedProperties = this.adaptDeprecatedProperties(properties, httpConfig);
        return new InProcessScannerEngineFacade(adaptedProperties, launcher, false, serverVersion);
    }

    @Nonnull
    Map<String, String> adaptDeprecatedProperties(Map<String, String> properties, HttpConfig httpConfig) {
        CertificateStore trustStore;
        Proxy proxy;
        HashMap<String, String> adaptedProperties = new HashMap<String, String>(properties);
        if (!adaptedProperties.containsKey("sonar.ws.timeout")) {
            adaptedProperties.put("sonar.ws.timeout", "" + httpConfig.getSocketTimeout().get(ChronoUnit.SECONDS));
        }
        if ((proxy = httpConfig.getProxy()) != null) {
            this.setSystemPropertyIfNotAlreadySet("http.proxyHost", ((InetSocketAddress)proxy.address()).getHostString());
            this.setSystemPropertyIfNotAlreadySet("https.proxyHost", ((InetSocketAddress)proxy.address()).getHostString());
            this.setSystemPropertyIfNotAlreadySet("http.proxyPort", "" + ((InetSocketAddress)proxy.address()).getPort());
            this.setSystemPropertyIfNotAlreadySet("https.proxyPort", "" + ((InetSocketAddress)proxy.address()).getPort());
        }
        this.setSystemPropertyIfNotAlreadySet("http.proxyUser", httpConfig.getProxyUser());
        this.setSystemPropertyIfNotAlreadySet("http.proxyPassword", httpConfig.getProxyPassword());
        CertificateStore keyStore = httpConfig.getSslConfig().getKeyStore();
        if (keyStore != null) {
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.keyStore", keyStore.getPath().toString());
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.keyStorePassword", keyStore.getKeyStorePassword());
        }
        if ((trustStore = httpConfig.getSslConfig().getTrustStore()) != null) {
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.trustStore", trustStore.getPath().toString());
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.trustStorePassword", trustStore.getKeyStorePassword());
        }
        return Map.copyOf(adaptedProperties);
    }

    private void setSystemPropertyIfNotAlreadySet(String key, String value) {
        if (this.system.getProperty(key) == null && StringUtils.isNotBlank(value)) {
            System.setProperty(key, value);
        }
    }

    private static Path resolveSonarUserHome(Map<String, String> properties) {
        String sonarUserHome;
        if (properties.containsKey("sonar.userHome")) {
            sonarUserHome = properties.get("sonar.userHome");
        } else {
            String userHome = Objects.requireNonNull(System.getProperty("user.home"), "The system property 'user.home' is expected to be non null");
            sonarUserHome = Paths.get(userHome, ".sonar").toAbsolutePath().toString();
        }
        return Paths.get(sonarUserHome, new String[0]);
    }

    private static String getServerVersion(ScannerHttpClient scannerHttpClient, boolean isSimulation, Map<String, String> properties) {
        if (isSimulation) {
            return properties.getOrDefault("sonar.scanner.internal.sqVersion", "5.6");
        }
        try {
            return scannerHttpClient.callRestApi("/analysis/version");
        }
        catch (Exception e) {
            try {
                return scannerHttpClient.callWebApi("/api/server/version");
            }
            catch (Exception e2) {
                IllegalStateException ex = new IllegalStateException("Failed to get server version", e2);
                ex.addSuppressed(e);
                throw ex;
            }
        }
    }

    private void initBootstrapDefaultValues() {
        this.setBootstrapPropertyIfNotAlreadySet("sonar.host.url", this.getSonarCloudUrl());
        this.setBootstrapPropertyIfNotAlreadySet("sonar.scanner.apiBaseUrl", (String)(this.isSonarCloud(this.bootstrapProperties) ? SONARCLOUD_REST_API : StringUtils.removeEnd(this.bootstrapProperties.get("sonar.host.url"), "/") + "/api/v2"));
        if (!this.bootstrapProperties.containsKey("sonar.scanner.os")) {
            this.setBootstrapProperty("sonar.scanner.os", new OsResolver(this.system, new Paths2()).getOs().name().toLowerCase(Locale.ENGLISH));
        }
        if (!this.bootstrapProperties.containsKey("sonar.scanner.arch")) {
            this.setBootstrapProperty("sonar.scanner.arch", new ArchResolver().getCpuArch());
        }
    }

    private String getSonarCloudUrl() {
        return this.bootstrapProperties.getOrDefault("sonar.scanner.sonarcloudUrl", SONARCLOUD_HOST);
    }

    private boolean isSonarCloud(Map<String, String> properties) {
        return this.getSonarCloudUrl().equals(properties.get("sonar.host.url"));
    }

    private void setBootstrapPropertyIfNotAlreadySet(String key, @Nullable String value) {
        if (!this.bootstrapProperties.containsKey(key) && value != null) {
            this.setBootstrapProperty(key, value);
        }
    }
}

