/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.http.ssl.SslConfig;

public class HttpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConfig.class);
    static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    static final Duration DEFAULT_RESPONSE_TIMEOUT = Duration.ZERO;
    public static final String READ_TIMEOUT_SEC_PROPERTY = "sonar.ws.timeout";
    static final Duration DEFAULT_READ_TIMEOUT_SEC = Duration.ofSeconds(60L);
    static final int DEFAULT_PROXY_PORT = 80;
    private final String webApiBaseUrl;
    private final String restApiBaseUrl;
    @Nullable
    private final String token;
    @Nullable
    private final String login;
    @Nullable
    private final String password;
    private final SslConfig sslConfig;
    private final Duration socketTimeout;
    private final Duration connectTimeout;
    private final Duration responseTimeout;
    @Nullable
    private final Proxy proxy;
    private final String proxyUser;
    private final String proxyPassword;
    private final String userAgent;

    public HttpConfig(Map<String, String> bootstrapProperties, Path sonarUserHome) {
        this.webApiBaseUrl = StringUtils.removeEnd(bootstrapProperties.get("sonar.host.url"), "/");
        this.restApiBaseUrl = StringUtils.removeEnd(bootstrapProperties.get("sonar.scanner.apiBaseUrl"), "/");
        this.token = bootstrapProperties.get("sonar.token");
        this.login = bootstrapProperties.get("sonar.login");
        this.password = bootstrapProperties.get("sonar.password");
        this.userAgent = String.format("%s/%s", bootstrapProperties.get("sonar.scanner.app"), bootstrapProperties.get("sonar.scanner.appVersion"));
        this.socketTimeout = HttpConfig.loadDuration(bootstrapProperties, "sonar.scanner.socketTimeout", READ_TIMEOUT_SEC_PROPERTY, DEFAULT_READ_TIMEOUT_SEC);
        this.connectTimeout = HttpConfig.loadDuration(bootstrapProperties, "sonar.scanner.connectTimeout", null, DEFAULT_CONNECT_TIMEOUT);
        this.responseTimeout = HttpConfig.loadDuration(bootstrapProperties, "sonar.scanner.responseTimeout", null, DEFAULT_RESPONSE_TIMEOUT);
        this.sslConfig = HttpConfig.loadSslConfig(bootstrapProperties, sonarUserHome);
        this.proxy = HttpConfig.loadProxy(bootstrapProperties);
        this.proxyUser = HttpConfig.loadProxyUser(bootstrapProperties);
        this.proxyPassword = HttpConfig.loadProxyPassword(bootstrapProperties);
    }

    private static String loadProxyPassword(Map<String, String> bootstrapProperties) {
        String scannerProxyPwd = bootstrapProperties.get("sonar.scanner.proxyPassword");
        return scannerProxyPwd != null ? scannerProxyPwd : System.getProperty("http.proxyPassword", "");
    }

    private static String loadProxyUser(Map<String, String> bootstrapProperties) {
        String scannerProxyUser = bootstrapProperties.get("sonar.scanner.proxyUser");
        return scannerProxyUser != null ? scannerProxyUser : System.getProperty("http.proxyUser", "");
    }

    private static Duration loadDuration(Map<String, String> bootstrapProperties, String propKey, @Nullable String deprecatedPropKey, Duration defaultValue) {
        if (bootstrapProperties.containsKey(propKey)) {
            return HttpConfig.parseDurationProperty(bootstrapProperties.get(propKey), propKey);
        }
        if (deprecatedPropKey != null && bootstrapProperties.containsKey(deprecatedPropKey)) {
            LOG.warn("Property {} is deprecated and will be removed in a future version. Please use {} instead.", (Object)deprecatedPropKey, (Object)propKey);
            return HttpConfig.parseDurationProperty(bootstrapProperties.get(deprecatedPropKey), deprecatedPropKey);
        }
        return defaultValue;
    }

    @Nullable
    private static Proxy loadProxy(Map<String, String> bootstrapProperties) {
        String proxyHost = StringUtils.defaultIfBlank(bootstrapProperties.get("sonar.scanner.proxyHost"), null);
        if (proxyHost != null) {
            int proxyPort = bootstrapProperties.containsKey("sonar.scanner.proxyPort") ? HttpConfig.parseIntProperty(bootstrapProperties.get("sonar.scanner.proxyPort"), "sonar.scanner.proxyPort") : 80;
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        }
        return null;
    }

    private static Duration parseDurationProperty(String propValue, String propKey) {
        try {
            return Duration.parse(propValue);
        }
        catch (DateTimeParseException e) {
            return Duration.ofSeconds(HttpConfig.parseIntProperty(propValue, propKey));
        }
    }

    private static int parseIntProperty(String propValue, String propKey) {
        try {
            return Integer.parseInt(propValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propKey + " is not a valid integer: " + propValue, e);
        }
    }

    private static SslConfig loadSslConfig(Map<String, String> bootstrapProperties, Path sonarUserHome) {
        CertificateStore keyStore = HttpConfig.loadKeyStoreConfig(bootstrapProperties, sonarUserHome);
        CertificateStore trustStore = HttpConfig.loadTrustStoreConfig(bootstrapProperties, sonarUserHome);
        return new SslConfig(keyStore, trustStore);
    }

    @Nullable
    private static CertificateStore loadTrustStoreConfig(Map<String, String> bootstrapProperties, Path sonarUserHome) {
        Path trustStorePath = HttpConfig.parseFileProperty(bootstrapProperties, "sonar.scanner.truststorePath", "truststore", sonarUserHome.resolve("ssl/truststore.p12"));
        if (trustStorePath != null) {
            LOG.debug("Using truststore: {}", (Object)trustStorePath);
            String trustStorePassword = StringUtils.defaultIfBlank(bootstrapProperties.get("sonar.scanner.truststorePassword"), "sonar");
            return new CertificateStore(trustStorePath, trustStorePassword);
        }
        return null;
    }

    @Nullable
    private static CertificateStore loadKeyStoreConfig(Map<String, String> bootstrapProperties, Path sonarUserHome) {
        Path keyStorePath = HttpConfig.parseFileProperty(bootstrapProperties, "sonar.scanner.keystorePath", "keystore", sonarUserHome.resolve("ssl/keystore.p12"));
        if (keyStorePath != null) {
            LOG.debug("Using keystore: {}", (Object)keyStorePath);
            String keyStorePassword = StringUtils.defaultIfBlank(bootstrapProperties.get("sonar.scanner.keystorePassword"), "sonar");
            return new CertificateStore(keyStorePath, keyStorePassword);
        }
        return null;
    }

    @Nullable
    private static Path parseFileProperty(Map<String, String> bootstrapProperties, String propKey, String labelForLogs, Path defaultPath) {
        if (bootstrapProperties.containsKey(propKey)) {
            Path keyStorePath = Paths.get(bootstrapProperties.get(propKey), new String[0]);
            if (!Files.exists(keyStorePath, new LinkOption[0])) {
                throw new IllegalArgumentException("The " + labelForLogs + " file does not exist: " + String.valueOf(keyStorePath));
            }
            return keyStorePath;
        }
        if (Files.isRegularFile(defaultPath, new LinkOption[0])) {
            return defaultPath;
        }
        return null;
    }

    public String getWebApiBaseUrl() {
        return this.webApiBaseUrl;
    }

    public String getRestApiBaseUrl() {
        return this.restApiBaseUrl;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }
}

