/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.NbDialog;
import org.netbeans.core.windows.services.NbPresenter;
import org.netbeans.core.windows.services.PresenterDecorator;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogDisplayerImpl
extends DialogDisplayer {
    private static List<Runnable> run = Collections.synchronizedList(new ArrayList());
    private Object testResult;

    public DialogDisplayerImpl() {
        this(null);
    }

    DialogDisplayerImpl(Object object) {
        this.testResult = object;
    }

    public static void runDelayed() {
        NbPresenter.LOG.fine("runDelayed");
        List<Runnable> list = run;
        run = null;
        if (list == null) {
            NbPresenter.LOG.fine("runDelayed, nothing");
            return;
        }
        assert (EventQueue.isDispatchThread());
        for (Runnable runnable : list) {
            NbPresenter.LOG.fine("runDelayed, run = " + runnable);
            runnable.run();
        }
        NbPresenter.LOG.fine("runDelayed, done");
    }

    public Dialog createDialog(DialogDescriptor dialogDescriptor) {
        return this.createDialog(dialogDescriptor, null);
    }

    public Dialog createDialog(final DialogDescriptor dialogDescriptor, final Frame frame) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return (Dialog)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Dialog>(){

            public Dialog run() {
                Container container;
                if (NbPresenter.currentModalDialog != null) {
                    NbDialog nbDialog = NbPresenter.currentModalDialog.isLeaf() ? new NbDialog(dialogDescriptor, WindowManager.getDefault().getMainWindow()) : new NbDialog(dialogDescriptor, NbPresenter.currentModalDialog);
                    DialogDisplayerImpl.customizeDlg(nbDialog);
                    return nbDialog;
                }
                Window window = frame;
                if (null == window) {
                    window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    if (!(window instanceof NbPresenter) || !window.isVisible()) {
                        if (!(window instanceof DefaultSeparateContainer.ModeUIBase)) {
                            container = SwingUtilities.getAncestorOfClass(Window.class, window);
                            window = container != null && container instanceof DefaultSeparateContainer.ModeUIBase ? (Window)container : WindowManager.getDefault().getMainWindow();
                        }
                    } else if (window instanceof NbPresenter && ((NbPresenter)window).isLeaf()) {
                        window = WindowManager.getDefault().getMainWindow();
                    }
                }
                if (window instanceof Dialog) {
                    container = new NbDialog(dialogDescriptor, (Dialog)window);
                } else {
                    Frame frame2 = window instanceof Frame ? (Frame)window : WindowManager.getDefault().getMainWindow();
                    container = new NbDialog(dialogDescriptor, frame2);
                }
                DialogDisplayerImpl.customizeDlg((NbPresenter)container);
                container.requestFocusInWindow();
                return container;
            }
        });
    }

    public Object notify(NotifyDescriptor notifyDescriptor) {
        return this.notify(notifyDescriptor, new AWTQuery(notifyDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notify(NotifyDescriptor notifyDescriptor, AWTQuery aWTQuery) {
        if (GraphicsEnvironment.isHeadless()) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            aWTQuery.showDialog();
            return notifyDescriptor.getValue();
        }
        AWTQuery aWTQuery2 = aWTQuery;
        synchronized (aWTQuery2) {
            SwingUtilities.invokeLater(aWTQuery);
            try {
                aWTQuery.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (aWTQuery.running) {
                while (aWTQuery.result == null) {
                    try {
                        aWTQuery.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return aWTQuery.result;
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
    }

    public void notifyLater(NotifyDescriptor notifyDescriptor) {
        this.notifyLater(new AWTQuery(notifyDescriptor));
    }

    private void notifyLater(AWTQuery aWTQuery) {
        Runnable runnable = () -> this.notify(aWTQuery.descriptor, aWTQuery);
        List<Runnable> list = run;
        if (list != null) {
            aWTQuery.noParent = true;
            list.add(runnable);
        } else {
            Mutex.EVENT.postReadRequest(runnable);
        }
    }

    private static void customizeDlg(NbPresenter nbPresenter) {
        for (PresenterDecorator presenterDecorator : Lookup.getDefault().lookupAll(PresenterDecorator.class)) {
            presenterDecorator.customizePresenter(nbPresenter);
        }
    }

    public <T extends NotifyDescriptor> CompletableFuture<T> notifyFuture(T t) {
        class AWTQuery2
        extends AWTQuery {
            volatile CompletableFuture res;

            public AWTQuery2(NotifyDescriptor notifyDescriptor) {
                super(notifyDescriptor);
            }

            @Override
            public void showDialog() {
                try {
                    super.showDialog();
                    Object object = this.descriptor.getValue();
                    if (this.cancelled || object == NotifyDescriptor.CLOSED_OPTION || object == NotifyDescriptor.CANCEL_OPTION) {
                        this.res.completeExceptionally(new CancellationException());
                    } else {
                        this.res.complete(this.descriptor);
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.res.completeExceptionally(throwable);
                }
            }
        }
        final AWTQuery2 aWTQuery2 = new AWTQuery2(t);
        class CF
        extends CompletableFuture<T> {
            CF() {
                aWTQuery2.res = this;
            }

            @Override
            public boolean cancel(boolean bl) {
                if (this.isDone()) {
                    return false;
                }
                aWTQuery2.cancel(bl);
                return super.cancel(bl);
            }
        }
        CF cF = new CF();
        aWTQuery2.res = cF;
        this.notifyLater(aWTQuery2);
        return cF;
    }

    class AWTQuery
    implements Runnable {
        public final NotifyDescriptor descriptor;
        public Object result;
        public boolean running;
        public volatile boolean noParent;
        public volatile boolean cancelled;
        NbPresenter presenter;

        public AWTQuery(NotifyDescriptor notifyDescriptor) {
            this.descriptor = notifyDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                this.notify();
                this.running = true;
            }
            this.showDialog();
            aWTQuery = this;
            synchronized (aWTQuery) {
                this.result = this.descriptor.getValue();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean bl) {
            NbPresenter nbPresenter;
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                if (this.cancelled) {
                    return false;
                }
                if (this.running && !bl) {
                    return false;
                }
                this.cancelled = true;
                nbPresenter = this.presenter;
                if (nbPresenter == null) {
                    return true;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                nbPresenter.setVisible(false);
            } else {
                SwingUtilities.invokeLater(() -> nbPresenter.setVisible(false));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showDialog() {
            Object object;
            Object object2;
            if (this.cancelled) {
                this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
                return;
            }
            if (DialogDisplayerImpl.this.testResult != null) {
                this.descriptor.setValue(DialogDisplayerImpl.this.testResult);
                return;
            }
            Component component = null;
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            for (object2 = topComponent; object2 != null && !(object2 instanceof Window); object2 = ((Component)object2).getParent()) {
            }
            if (object2 != null) {
                component = ((Window)object2).getFocusOwner();
            }
            NbPresenter nbPresenter = null;
            if (this.descriptor instanceof DialogDescriptor) {
                if (NbPresenter.currentModalDialog != null) {
                    nbPresenter = NbPresenter.currentModalDialog.isLeaf() ? new NbDialog((DialogDescriptor)this.descriptor, WindowManager.getDefault().getMainWindow()) : new NbDialog((DialogDescriptor)this.descriptor, NbPresenter.currentModalDialog);
                } else {
                    Frame frame;
                    object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    if (object instanceof NbPresenter && ((NbPresenter)object).isLeaf()) {
                        object = WindowManager.getDefault().getMainWindow();
                    }
                    Frame frame2 = frame = object instanceof Frame ? (Frame)object : WindowManager.getDefault().getMainWindow();
                    if (this.noParent) {
                        frame = null;
                    }
                    nbPresenter = new NbDialog((DialogDescriptor)this.descriptor, frame);
                }
            } else if (NbPresenter.currentModalDialog != null) {
                nbPresenter = NbPresenter.currentModalDialog.isLeaf() ? new NbPresenter(this.descriptor, WindowManager.getDefault().getMainWindow(), true) : new NbPresenter(this.descriptor, NbPresenter.currentModalDialog, true);
            } else {
                Object object3 = object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() instanceof Frame ? (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : WindowManager.getDefault().getMainWindow();
                if (this.noParent) {
                    object = null;
                }
                nbPresenter = new NbPresenter(this.descriptor, (Frame)object, true);
            }
            object = this;
            synchronized (object) {
                this.presenter = nbPresenter;
            }
            if ("true".equals(System.getProperty("javahelp.ignore.modality"))) {
                nbPresenter.getRootPane().putClientProperty("javahelp.ignore.modality", "true");
                System.setProperty("javahelp.ignore.modality", "false");
            }
            DialogDisplayerImpl.customizeDlg(nbPresenter);
            nbPresenter.getRootPane().requestDefaultFocus();
            nbPresenter.setVisible(true);
            if (component != null) {
                ((Component)object2).requestFocusInWindow();
                topComponent.requestFocusInWindow();
                if (!(component instanceof JRootPane)) {
                    component.requestFocusInWindow();
                }
            }
        }
    }
}

