/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.FilteredIcon;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.spi.SVGLoader;

public final class ImageUtilities {
    public static final String PROPERTY_URL = "url";
    private static final Logger LOGGER = Logger.getLogger(ImageUtilities.class.getName());
    static final String TOOLTIP_SEPAR = "<br>";
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> imageToolTipCache = new HashMap<ToolTipImageKey, ActiveRef<ToolTipImageKey>>(128);
    private static RGBImageFilter imageIconFilter = null;
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static final CachedLookupLoader<ClassLoader> classLoaderLoader = new CachedLookupLoader<ClassLoader>(ClassLoader.class);
    private static final CachedLookupLoader<SVGLoader> svgLoaderLoader = new CachedLookupLoader<SVGLoader>(SVGLoader.class);
    private static final Component component = new Component(){};
    private static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;
    private static final String DARK_LAF_SUFFIX = "_dark";
    private static volatile Component dummyIconComponentLabel;
    private static volatile Component dummyIconComponentButton;

    private ImageUtilities() {
    }

    public static final Image loadImage(String string) {
        return ImageUtilities.loadImage(string, false);
    }

    public static final Image loadImage(String string, boolean bl) {
        return ImageUtilities.loadImageInternal(string, bl);
    }

    private static ToolTipImage loadImageInternal(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        ToolTipImage toolTipImage = null;
        if (ImageUtilities.isDarkLaF()) {
            toolTipImage = ImageUtilities.getIcon(ImageUtilities.addDarkSuffix(string), bl);
        }
        if (null == toolTipImage) {
            toolTipImage = ImageUtilities.getIcon(string, bl);
            RGBImageFilter rGBImageFilter = ImageUtilities.getImageIconFilter();
            if (null != toolTipImage && null != rGBImageFilter) {
                toolTipImage = ImageUtilities.icon2ToolTipImage(FilteredIcon.create(rGBImageFilter, toolTipImage), toolTipImage.url);
            }
        }
        return toolTipImage;
    }

    public static final ImageIcon loadImageIcon(String string, boolean bl) {
        ToolTipImage toolTipImage = ImageUtilities.loadImageInternal(string, bl);
        if (toolTipImage == null) {
            return null;
        }
        return toolTipImage.asImageIcon();
    }

    private static boolean isDarkLaF() {
        return UIManager.getBoolean("nb.dark.theme");
    }

    private static String addDarkSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n) + DARK_LAF_SUFFIX + string.substring(n);
        }
        return string + DARK_LAF_SUFFIX;
    }

    private static RGBImageFilter getImageIconFilter() {
        Object object;
        if (null == imageIconFilter && (object = UIManager.get("nb.imageicon.filter")) instanceof RGBImageFilter) {
            imageIconFilter = (RGBImageFilter)object;
        }
        return imageIconFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image mergeImages(Image image, Image image2, int n, int n2) {
        if (image == null || image2 == null) {
            throw new NullPointerException();
        }
        CompositeImageKey compositeImageKey = new CompositeImageKey(image, image2, n, n2);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            ToolTipImage toolTipImage;
            ActiveRef<CompositeImageKey> activeRef = compositeCache.get(compositeImageKey);
            if (activeRef != null && (toolTipImage = (ToolTipImage)activeRef.get()) != null) {
                return toolTipImage;
            }
            toolTipImage = ImageUtilities.doMergeImages(image, image2, n, n2);
            compositeCache.put(compositeImageKey, new ActiveRef<CompositeImageKey>(toolTipImage, compositeCache, compositeImageKey));
            return toolTipImage;
        }
    }

    public static final Icon image2Icon(Image image) {
        return image instanceof ToolTipImage ? (ToolTipImage)image : ImageUtilities.assignToolTipToImageInternal(image, "");
    }

    public static final Image icon2Image(Icon icon) {
        Image image;
        if (icon == null) {
            LOGGER.log(Level.WARNING, null, new NullPointerException());
            return ImageUtilities.loadImage("org/openide/nodes/defaultNode.png", true);
        }
        if (icon instanceof ToolTipImage) {
            return (ToolTipImage)icon;
        }
        if (icon instanceof IconImageIcon) {
            return ImageUtilities.icon2Image(((IconImageIcon)icon).getDelegateIcon());
        }
        if (icon instanceof ImageIcon && (image = ((ImageIcon)icon).getImage()) != null) {
            return image;
        }
        return ImageUtilities.icon2ToolTipImage(icon, null);
    }

    private static ToolTipImage icon2ToolTipImage(Icon icon, URL uRL) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        if (icon instanceof ToolTipImage) {
            return (ToolTipImage)icon;
        }
        ToolTipImage toolTipImage = new ToolTipImage(icon, "", uRL, 2);
        Graphics graphics = toolTipImage.getGraphics();
        try {
            icon.paintIcon(dummyIconComponentLabel, graphics, 0, 0);
        }
        catch (ClassCastException classCastException) {
            icon.paintIcon(dummyIconComponentButton, graphics, 0, 0);
        }
        graphics.dispose();
        return toolTipImage;
    }

    public static final Image assignToolTipToImage(Image image, String string) {
        return ImageUtilities.assignToolTipToImageInternal(image, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage assignToolTipToImageInternal(Image image, String string) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        Parameters.notNull((CharSequence)"text", (Object)string);
        ToolTipImageKey toolTipImageKey = new ToolTipImageKey(image, string);
        Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> map = imageToolTipCache;
        synchronized (map) {
            ToolTipImage toolTipImage;
            ActiveRef<ToolTipImageKey> activeRef = imageToolTipCache.get(toolTipImageKey);
            if (activeRef != null && (toolTipImage = (ToolTipImage)activeRef.get()) != null) {
                return toolTipImage;
            }
            toolTipImage = ToolTipImage.createNew(string, image, null);
            imageToolTipCache.put(toolTipImageKey, new ActiveRef<ToolTipImageKey>(toolTipImage, imageToolTipCache, toolTipImageKey));
            return toolTipImage;
        }
    }

    public static final String getImageToolTip(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).toolTipText;
        }
        return "";
    }

    public static final Image addToolTipToImage(Image image, String string) {
        if (image instanceof ToolTipImage) {
            ToolTipImage toolTipImage = (ToolTipImage)image;
            StringBuilder stringBuilder = new StringBuilder(toolTipImage.toolTipText);
            if (stringBuilder.length() > 0 && string.length() > 0) {
                stringBuilder.append(TOOLTIP_SEPAR);
            }
            stringBuilder.append(string);
            return ImageUtilities.assignToolTipToImage(image, stringBuilder.toString());
        }
        return ImageUtilities.assignToolTipToImage(image, string);
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        return FilteredIcon.create(DisabledButtonFilter.INSTANCE, icon);
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        return ImageUtilities.icon2Image(ImageUtilities.createDisabledIcon(ImageUtilities.image2Icon(image)));
    }

    public static URL findImageBaseURL(Image image) {
        Object object = image.getProperty(PROPERTY_URL, null);
        return object instanceof URL ? (URL)object : null;
    }

    private static SVGLoader getSVGLoader() {
        return svgLoaderLoader.getLoader();
    }

    static ClassLoader getClassLoader() {
        return classLoaderLoader.getLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ToolTipImage getIcon(String string, boolean bl) {
        if (bl) {
            if (string == null) {
                return null;
            }
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String string2;
                String string3;
                ActiveRef<String> activeRef = localizedCache.get(string);
                ToolTipImage toolTipImage = null;
                if (activeRef == NO_ICON) {
                    return null;
                }
                if (activeRef != null) {
                    toolTipImage = (ToolTipImage)activeRef.get();
                }
                if (toolTipImage != null) {
                    return toolTipImage;
                }
                ClassLoader classLoader = ImageUtilities.getClassLoader();
                int n = (string = new String(string).intern()).lastIndexOf(46);
                if (n != -1 && n > string.lastIndexOf(47)) {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n);
                } else {
                    string3 = string;
                    string2 = "";
                }
                URL uRL = classLoader != null ? classLoader.getResource(string) : ImageUtilities.class.getClassLoader().getResource(string);
                Iterator iterator = NbBundle.getLocalizingSuffixes();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    ToolTipImage toolTipImage2 = string4.length() == 0 ? ImageUtilities.getIcon(string, classLoader, false) : ImageUtilities.getIcon(string3 + string4 + string2, classLoader, true);
                    if (toolTipImage2 == null) continue;
                    localizedCache.put(string, new ActiveRef<String>(toolTipImage2, localizedCache, string));
                    return toolTipImage2;
                }
                localizedCache.put(string, NO_ICON);
                return null;
            }
        }
        return ImageUtilities.getIcon(string, ImageUtilities.getClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage getIcon(String string, ClassLoader classLoader, boolean bl) {
        if (string == null) {
            return null;
        }
        ActiveRef<String> activeRef = cache.get(string);
        ToolTipImage toolTipImage = null;
        if (activeRef == NO_ICON) {
            return null;
        }
        if (activeRef != null) {
            toolTipImage = (ToolTipImage)activeRef.get();
        }
        if (toolTipImage != null) {
            return toolTipImage;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            Object object;
            Object object2;
            Object object3;
            String string2;
            boolean bl2;
            block30: {
                activeRef = cache.get(string);
                if (activeRef == NO_ICON) {
                    return null;
                }
                if (activeRef != null) {
                    toolTipImage = (ToolTipImage)activeRef.get();
                }
                if (toolTipImage != null) {
                    return toolTipImage;
                }
                if (string.startsWith("/")) {
                    bl2 = true;
                    string2 = string.substring(1);
                } else {
                    bl2 = false;
                    string2 = string;
                }
                SVGLoader sVGLoader = null;
                ClassLoader classLoader2 = classLoader != null ? classLoader : ImageUtilities.class.getClassLoader();
                object3 = null;
                if ((string2.endsWith(".png") || string2.endsWith(".gif") || string2.endsWith(".svg")) && (object2 = classLoader2.getResource(string2.substring(0, string2.length() - 4) + ".svg")) != null) {
                    sVGLoader = ImageUtilities.getSVGLoader();
                    if (sVGLoader != null) {
                        object3 = object2;
                    } else {
                        ERR.log(Level.INFO, "No SVG loader available for loading {0}", object2);
                    }
                }
                if (object3 == null && !string2.endsWith(".svg")) {
                    object3 = classLoader2.getResource(string2);
                }
                object2 = null;
                try {
                    if (object3 == null) break block30;
                    if (sVGLoader != null) {
                        try {
                            object2 = ImageUtilities.icon2ToolTipImage(sVGLoader.loadIcon((URL)object3), (URL)object3);
                        }
                        catch (IOException iOException) {
                            ERR.log(Level.INFO, "Failed to load SVG image " + object3, iOException);
                        }
                    } else if (string.endsWith(".png")) {
                        object = ImageIO.createImageInputStream(((URL)object3).openStream());
                        ImageReadParam imageReadParam = PNG_READER.getDefaultReadParam();
                        try {
                            PNG_READER.setInput(object, true, true);
                            object2 = PNG_READER.read(0, imageReadParam);
                        }
                        catch (IOException iOException) {
                            ERR.log(Level.INFO, "Image " + string + " is not PNG", iOException);
                        }
                        object.close();
                    }
                    if (object2 == null) {
                        object2 = ImageIO.read((URL)object3);
                    }
                }
                catch (IOException iOException) {
                    ERR.log(Level.WARNING, "Cannot load " + string + " image", iOException);
                }
            }
            if (object2 != null) {
                if (bl2 && extraInitialSlashes.add(string)) {
                    ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + string);
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{string2, object2});
                }
                string = new String(string).intern();
                object = object2 instanceof ToolTipImage ? (ToolTipImage)object2 : ToolTipImage.createNew("", (Image)object2, (URL)object3);
                cache.put(string, new ActiveRef<String>((ToolTipImage)object, cache, string));
                return object;
            }
            if (!bl) {
                cache.put(string, NO_ICON);
            }
            return null;
        }
    }

    private static final Image toBufferedImage(Image image) {
        new ImageIcon(image, "");
        if (image.getHeight(null) * image.getWidth(null) > 576) {
            return image;
        }
        BufferedImage bufferedImage = ImageUtilities.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int n = ++mediaTrackerID;
            tracker.addImage(image, n);
            try {
                tracker.waitForID(n, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, n);
        }
    }

    private static final ToolTipImage doMergeImages(Image image, Image image2, int n, int n2) {
        Object object;
        ImageUtilities.ensureLoaded(image);
        ImageUtilities.ensureLoaded(image2);
        int n3 = Math.max(1, Math.max(image.getWidth(null), n + image2.getWidth(null)));
        int n4 = Math.max(1, Math.max(image.getHeight(null), n2 + image2.getHeight(null)));
        boolean bl = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3 && image2 instanceof Transparency && ((Transparency)((Object)image2)).getTransparency() != 3;
        StringBuilder stringBuilder = new StringBuilder(image instanceof ToolTipImage ? ((ToolTipImage)image).toolTipText : "");
        if (image2 instanceof ToolTipImage) {
            object = ((ToolTipImage)image2).toolTipText;
            if (stringBuilder.length() > 0 && ((String)object).length() > 0) {
                stringBuilder.append(TOOLTIP_SEPAR);
            }
            stringBuilder.append((String)object);
        }
        object = image.getProperty(PROPERTY_URL, null);
        ColorModel colorModel = ImageUtilities.colorModel(bl ? 2 : 3);
        MergedIcon mergedIcon = new MergedIcon(ImageUtilities.image2Icon(image), ImageUtilities.image2Icon(image2), n, n2);
        ToolTipImage toolTipImage = new ToolTipImage(stringBuilder.toString(), mergedIcon, colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null, object instanceof URL ? (URL)object : null);
        Graphics2D graphics2D = toolTipImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.drawImage(image2, n, n2, null);
        graphics2D.dispose();
        return toolTipImage;
    }

    static final BufferedImage createBufferedImage(int n, int n2) {
        if (Utilities.isMac()) {
            return new BufferedImage(n, n2, 3);
        }
        ColorModel colorModel = ImageUtilities.colorModel(3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    private static ColorModel colorModel(int n) {
        ColorModel colorModel;
        try {
            colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            colorModel = ColorModel.getRGBdefault();
        }
        catch (HeadlessException headlessException) {
            colorModel = ColorModel.getRGBdefault();
        }
        return colorModel;
    }

    static {
        ERR = Logger.getLogger(ImageUtilities.class.getName());
        if (EventQueue.isDispatchThread()) {
            dummyIconComponentLabel = new JLabel();
            dummyIconComponentButton = new JCheckBox();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dummyIconComponentLabel = new JLabel();
                    dummyIconComponentButton = new JCheckBox();
                }
            });
        }
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        public static final RGBImageFilter INSTANCE = new DisabledButtonFilter();

        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            return (n3 & 0xFF000000) + 0x888888 + ((n3 >> 16 & 0xFF) >> 2 << 16) + ((n3 >> 8 & 0xFF) >> 2 << 8) + ((n3 & 0xFF) >> 2);
        }

        public void setProperties(Hashtable hashtable) {
            hashtable = (Hashtable)hashtable.clone();
            this.consumer.setProperties(hashtable);
        }
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon {
        final String toolTipText;
        final Icon delegateIcon;
        final URL url;
        ImageIcon imageIconVersion;

        public static ToolTipImage createNew(String string, Image image, URL uRL) {
            Object object;
            ImageUtilities.ensureLoaded(image);
            boolean bl = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3;
            ColorModel colorModel = ImageUtilities.colorModel(bl ? 2 : 3);
            int n = Math.max(1, image.getWidth(null));
            int n2 = Math.max(1, image.getHeight(null));
            if (uRL == null) {
                object = image.getProperty(ImageUtilities.PROPERTY_URL, null);
                uRL = object instanceof URL ? (URL)object : null;
            }
            object = image instanceof ToolTipImage ? ((ToolTipImage)image).getDelegateIcon() : null;
            ToolTipImage toolTipImage = new ToolTipImage(string, (Icon)object, colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null, uRL);
            Graphics2D graphics2D = toolTipImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return toolTipImage;
        }

        public ToolTipImage(String string, Icon icon, ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable<?, ?> hashtable, URL uRL) {
            super(colorModel, writableRaster, bl, hashtable);
            this.toolTipText = string;
            this.delegateIcon = icon;
            this.url = uRL;
        }

        public synchronized ImageIcon asImageIcon() {
            if (this.imageIconVersion == null) {
                this.imageIconVersion = IconImageIcon.create(this);
            }
            return this.imageIconVersion;
        }

        public ToolTipImage(Icon icon, String string, URL uRL, int n) {
            super(Math.max(1, icon.getIconWidth()), Math.max(1, icon.getIconHeight()), n);
            this.delegateIcon = icon;
            this.toolTipText = string;
            this.url = uRL;
        }

        public Icon getDelegateIcon() {
            return this.delegateIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.delegateIcon != null) {
                this.delegateIcon.paintIcon(component, graphics, n, n2);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                try {
                    AffineTransform affineTransform = graphics2D.getTransform();
                    int n3 = affineTransform.getType();
                    double d = n3 == 2 || n3 == 3 ? affineTransform.getScaleX() : 1.0;
                    if (d != 1.0) {
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        graphics2D.setTransform(new AffineTransform(d, 0.0, 0.0, d, (double)((int)affineTransform.getTranslateX()), (double)((int)affineTransform.getTranslateY())));
                    }
                    graphics2D.drawImage((Image)this, n, n2, null);
                }
                finally {
                    graphics2D.dispose();
                }
            }
        }

        @Override
        public Object getProperty(String string, ImageObserver imageObserver) {
            if (ImageUtilities.PROPERTY_URL.equals(string)) {
                if (this.url != null) {
                    return this.url;
                }
                if (!(this.delegateIcon instanceof ImageIcon)) {
                    return null;
                }
                Image image = ((ImageIcon)this.delegateIcon).getImage();
                if (image == this || image == null) {
                    return null;
                }
                return image.getProperty(string, imageObserver);
            }
            return super.getProperty(string, imageObserver);
        }
    }

    private static final class IconImageIcon
    extends ImageIcon {
        private volatile Icon delegate;

        private IconImageIcon(Icon icon) {
            super(ImageUtilities.icon2Image(icon));
            Parameters.notNull((CharSequence)"delegate", (Object)icon);
            this.delegate = icon;
        }

        private static ImageIcon create(Icon icon) {
            return icon instanceof ImageIcon ? (ImageIcon)icon : new IconImageIcon(icon);
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.delegate.paintIcon(component, graphics, n, n2);
        }

        public Icon getDelegateIcon() {
            return this.delegate;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(new ImageIcon(this.getImage()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.delegate = (ImageIcon)objectInputStream.readObject();
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.delegate = new ImageIcon(new BufferedImage(1, 1, 6));
        }
    }

    private static final class ActiveRef<T>
    extends SoftReference<ToolTipImage>
    implements Runnable {
        private final Map<T, ActiveRef<T>> holder;
        private final T key;

        public ActiveRef(ToolTipImage toolTipImage, Map<T, ActiveRef<T>> map, T t) {
            super(toolTipImage, Utilities.activeReferenceQueue());
            this.holder = map;
            this.key = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class ToolTipImageKey {
        Image image;
        String str;

        ToolTipImageKey(Image image, String string) {
            this.image = image;
            this.str = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ToolTipImageKey)) {
                return false;
            }
            ToolTipImageKey toolTipImageKey = (ToolTipImageKey)object;
            return this.str.equals(toolTipImageKey.str) && this.image == toolTipImageKey.image;
        }

        public int hashCode() {
            return System.identityHashCode(this.image) ^ this.str.hashCode();
        }

        public String toString() {
            return "ImageStringKey for " + this.image + " + " + this.str;
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image image, Image image2, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.baseImage = image;
            this.overlayImage = image2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey compositeImageKey = (CompositeImageKey)object;
            return this.x == compositeImageKey.x && this.y == compositeImageKey.y && this.baseImage == compositeImageKey.baseImage && this.overlayImage == compositeImageKey.overlayImage;
        }

        public int hashCode() {
            int n = (this.x << 3 ^ this.y) << 4;
            n = n ^ System.identityHashCode(this.baseImage) ^ System.identityHashCode(this.overlayImage);
            return n;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }

    private static final class MergedIcon
    extends CachedHiDPIIcon {
        private final Icon icon1;
        private final Icon icon2;
        private final int x;
        private final int y;

        public MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            super(Math.max(icon.getIconWidth(), n + icon2.getIconWidth()), Math.max(icon.getIconHeight(), n2 + icon2.getIconHeight()));
            this.icon1 = icon;
            this.icon2 = icon2;
            this.x = n;
            this.y = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Image createAndPaintImage(Component component, ColorModel colorModel, int n, int n2, double d) {
            BufferedImage bufferedImage = MergedIcon.createBufferedImage(colorModel, n, n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                graphics2D.clip(new Rectangle(0, 0, n, n2));
                graphics2D.scale(d, d);
                this.icon1.paintIcon(component, graphics2D, 0, 0);
                this.icon2.paintIcon(component, graphics2D, this.x, this.y);
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage;
        }
    }

    private static final class CachedLookupLoader<T> {
        private final Class<T> clazz;
        private final AtomicBoolean noLoaderWarned = new AtomicBoolean(false);
        private volatile Optional<T> currentLoader;
        private Thread threadInProgress;
        private Lookup.Result<T> loaderQuery;

        public CachedLookupLoader(Class<T> clazz) {
            Parameters.notNull((CharSequence)"clazz", clazz);
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getLoader() {
            Lookup.Result<T> result;
            Optional<Object> optional = this.currentLoader;
            if (optional != null) {
                return optional.orElse(null);
            }
            Object object = this;
            synchronized (object) {
                this.threadInProgress = Thread.currentThread();
                if (this.loaderQuery == null) {
                    this.loaderQuery = Lookup.getDefault().lookupResult(this.clazz);
                    this.loaderQuery.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            ERR.log(Level.FINE, "Loader for {0} cleared", clazz);
                            CachedLookupLoader cachedLookupLoader = this;
                            synchronized (cachedLookupLoader) {
                                currentLoader = null;
                                threadInProgress = null;
                            }
                        }
                    });
                }
                result = this.loaderQuery;
            }
            object = result.allInstances().iterator();
            optional = Optional.ofNullable(object.hasNext() ? (Object)object.next() : null);
            if (!optional.isPresent()) {
                if (!this.noLoaderWarned.getAndSet(true)) {
                    ERR.log(Level.WARNING, "No {0} instance found in {1}", new Object[]{this.clazz, Lookup.getDefault()});
                }
            } else if (ERR.isLoggable(Level.FINE)) {
                ERR.log(Level.FINE, "Loader computed for {0}: {1}", new Object[]{this.clazz, optional.orElse(null)});
            }
            CachedLookupLoader cachedLookupLoader = this;
            synchronized (cachedLookupLoader) {
                if (this.threadInProgress == Thread.currentThread()) {
                    this.threadInProgress = null;
                    this.currentLoader = optional;
                }
            }
            return optional.orElse(null);
        }
    }
}

