/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

class ConsumerIterator
implements Iterator {
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;
    private BrokerAddress from = null;
    private GPacket gp = null;

    public ConsumerIterator(GPacket gp, byte[] payload, int count, BrokerAddress from) {
        ByteArrayInputStream bis = new ByteArrayInputStream(payload);
        this.dis = new DataInputStream(bis);
        this.count = count;
        this.count_read = 0;
        this.from = from;
        this.gp = gp;
    }

    @Override
    public boolean hasNext() {
        if (this.count_read < 0) {
            throw new IllegalStateException("ConsumerUID");
        }
        return this.count_read < this.count;
    }

    public Object next() throws RuntimeException {
        try {
            Consumer c = ClusterConsumerInfo.readConsumer(this.dis);
            Integer prefetch = (Integer)this.gp.getProp(String.valueOf(c.getConsumerUID().longValue()) + ":" + "prefetch");
            if (prefetch != null) {
                c.setRemotePrefetch(prefetch);
            }
            if (this.from != null) {
                c.getConsumerUID().setBrokerAddress(this.from);
            }
            ++this.count_read;
            return c;
        }
        catch (IOException e) {
            Throwable ex = e.getCause();
            if (ex instanceof ConsumerAlreadyAddedException) {
                ++this.count_read;
                throw new RuntimeException(ex);
            }
            this.count_read = -1;
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

