/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.router;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.cluster.router.MultibrokerRouter;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.MQThread;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class BrokerConsumers
implements Runnable,
EventListener {
    private static String REDELIVER_REMOTE_REJECTED = "imq.cluster.disableRedeliverRemoteRejectedMsg";
    Thread thr = null;
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    Protocol protocol = null;
    boolean valid = true;
    Set activeConsumers = Collections.synchronizedSet(new LinkedHashSet());
    Map consumers = Collections.synchronizedMap(new HashMap());
    Map listeners = Collections.synchronizedMap(new HashMap());
    private FaultInjection fi = null;
    public static int BTOBFLOW = Globals.getConfig().getIntProperty("imq.cluster.consumerFlowLimit", 1000);
    DestinationList DL = Globals.getDestinationList();
    Map deliveredMessages = new LinkedHashMap();
    Map cleanupList = new HashMap();
    private Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>> pendingConsumerUIDs = Collections.synchronizedMap(new LinkedHashMap());
    private Object pendingCheckTimerLock = new Object();
    private boolean pendingCheckTimerShutdown = false;
    private WakeupableTimer pendingCheckTimer = null;
    public static int pendingCheckInterval = Globals.getConfig().getIntProperty("imq.cluster.pendingTransactionCheckInterval", 180);
    private Object removeConsumerLock = new Object();

    private static boolean getDEBUG() {
        return MultibrokerRouter.getDEBUG();
    }

    public BrokerConsumers(Protocol p) {
        this.protocol = p;
        if (pendingCheckInterval < p.getClusterAckWaitTimeout()) {
            pendingCheckInterval = p.getClusterAckWaitTimeout();
        }
        this.fi = FaultInjection.getInjection();
        MQThread thr = new MQThread((Runnable)this, "Cluster-BrokerConsumers");
        thr.setDaemon(true);
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPendingCheckTimer() {
        Object object = this.pendingCheckTimerLock;
        synchronized (object) {
            if (pendingCheckInterval > 0 && this.pendingCheckTimer == null && !this.pendingCheckTimerShutdown) {
                this.pendingCheckTimer = new WakeupableTimer("ClusterRouterPendingTransactionTimer", (TimerEventHandler)new PendingCheckEventHandler(), (long)pendingCheckInterval * 1000L, (long)pendingCheckInterval * 1000L, this.br.getKString("B1472"), this.br.getKString("B1473"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object cuid3;
        Object c2;
        Object cuid22;
        Object e2;
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ArrayList<Object> l = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            l = new ArrayList(this.deliveredMessages.values());
        }
        ht.put("CLUSTER_ROUTER:deliveredMessagesCount", l.size());
        for (Object e2 : l) {
            SysMessageID id = ((AckEntry)e2).getSysMessageID();
            ht.put("[deliveredMessages]" + id.toString(), ((AckEntry)e2).toString());
        }
        e2 = this.consumers;
        synchronized (e2) {
            l = new ArrayList(this.consumers.keySet());
        }
        ht.put("consumersCount", l.size());
        for (Object cuid22 : l) {
            c2 = (Consumer)this.consumers.get(cuid22);
            if (c2 instanceof Subscription) {
                ht.put("[consumers]" + ((ConsumerUID)cuid22).toString(), "Subscription: " + c2);
                continue;
            }
            ht.put("[consumers]" + ((ConsumerUID)cuid22).toString(), ((Consumer)c2).toString());
        }
        cuid22 = this.activeConsumers;
        synchronized (cuid22) {
            l = new ArrayList(this.activeConsumers);
        }
        ht.put("activeConsumersCount", l.size());
        Vector<String> v = new Vector<String>();
        for (Object c2 : l) {
            if (c2 instanceof Subscription) {
                v.add("Subscription: " + c2);
                continue;
            }
            v.add(((Consumer)c2).toString());
        }
        ht.put("activeConsumers", v);
        c2 = this.pendingConsumerUIDs;
        synchronized (c2) {
            l = new ArrayList<ConsumerUID>(this.pendingConsumerUIDs.keySet());
        }
        ht.put("pendingConsumerUIDsCount", l.size());
        for (Object cuid3 : l) {
            LinkedHashMap<TransactionUID, Set<AckEntry>> pending = null;
            Map map2 = this.deliveredMessages;
            synchronized (map2) {
                Map<TransactionUID, Set<AckEntry>> pending0 = this.pendingConsumerUIDs.get(cuid3);
                if (pending0 != null) {
                    pending = new LinkedHashMap<TransactionUID, Set<AckEntry>>(pending0);
                }
            }
            if (pending == null) {
                ht.put("[pendingConsumerUIDs]" + ((ConsumerUID)cuid3).toString(), "null");
                continue;
            }
            Hashtable htt = new Hashtable();
            Map.Entry pair2 = null;
            TransactionUID key = null;
            for (Map.Entry pair2 : pending.entrySet()) {
                key = (TransactionUID)pair2.getKey();
                htt.put("PENDING-TID:" + (key == null ? "null" : key), new Vector((Collection)pair2.getValue()));
            }
            ht.put("[pendingConsumerUIDs]" + ((ConsumerUID)cuid3).toString(), htt);
        }
        cuid3 = this.cleanupList;
        synchronized (cuid3) {
            l = new ArrayList(this.cleanupList.keySet());
        }
        ht.put("cleanupListCount", l.size());
        v = new Vector();
        for (Object cuid3 : l) {
            v.add(((ConsumerUID)cuid3).toString());
        }
        ht.put("cleanupList", v);
        cuid3 = this.listeners;
        synchronized (cuid3) {
            l = new ArrayList(this.listeners.keySet());
        }
        ht.put("listenersCount", l.size());
        v = new Vector();
        for (Object cuid3 : l) {
            v.add(((ConsumerUID)cuid3).toString());
        }
        ht.put("listeners", v);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.valid = false;
        Object object = this.activeConsumers;
        synchronized (object) {
            this.activeConsumers.notifyAll();
        }
        object = this.pendingCheckTimerLock;
        synchronized (object) {
            this.pendingCheckTimerShutdown = true;
            if (this.pendingCheckTimer != null) {
                this.pendingCheckTimer.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        if (type != EventType.BUSY_STATE_CHANGED) assert (false);
        Consumer c = (Consumer)target;
        Set set = this.activeConsumers;
        synchronized (set) {
            if (c.isBusy()) {
                this.activeConsumers.add(c);
            }
            this.activeConsumers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress address) throws BrokerException {
        if (BrokerConsumers.getDEBUG()) {
            this.logger.log(8, "BrokerConsumers.brokerDown:" + address);
        }
        HashSet<ConsumerUID> removedConsumers = new HashSet<ConsumerUID>();
        ConsumerUID cuid2 = null;
        Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>> map = this.consumers;
        synchronized (map) {
            for (ConsumerUID cuid2 : this.consumers.keySet()) {
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Check remote consumer " + cuid2 + " from " + cuid2.getBrokerAddress());
                }
                if (!address.equals(cuid2.getBrokerAddress()) || address.getBrokerSessionUID() != null && !address.getBrokerSessionUID().equals((Object)cuid2.getBrokerAddress().getBrokerSessionUID())) continue;
                removedConsumers.add(cuid2);
            }
        }
        map = this.pendingConsumerUIDs;
        synchronized (map) {
            for (ConsumerUID cuid2 : this.pendingConsumerUIDs.keySet()) {
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Check closed remote consumer " + cuid2 + " from " + cuid2.getBrokerAddress());
                }
                if (!address.equals(cuid2.getBrokerAddress()) || address.getBrokerSessionUID() != null && !address.getBrokerSessionUID().equals((Object)cuid2.getBrokerAddress().getBrokerSessionUID())) continue;
                removedConsumers.add(cuid2);
            }
        }
        for (ConsumerUID cuid2 : removedConsumers) {
            this.removeConsumer(cuid2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardMessageToRemote(PacketReference ref, Collection cons) {
        for (Consumer consumer : cons) {
            ConsumerUID sid = consumer.getStoredConsumerUID();
            ConsumerUID uid = consumer.getConsumerUID();
            if (uid.isNoAck()) continue;
            Object object = this.removeConsumerLock;
            synchronized (object) {
                if (this.consumers.get(uid) == null) {
                    if (BrokerConsumers.getDEBUG()) {
                        Globals.getLogger().log(8, "BrokerConsumers.forwardMessageToRemote(): " + ref + ", ignore removed consumer: " + consumer);
                    }
                    try {
                        if (ref.acknowledged(uid, sid, !uid.isDupsOK(), false)) {
                            Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                            Destination d = ds[0];
                            d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                    }
                    catch (Exception e) {
                        this.logger.logStack(16, "Unable to cleanup message " + ref.getSysMessageID() + " for closed consumer " + uid, (Throwable)e);
                    }
                    continue;
                }
                AckEntry entry = new AckEntry(ref, uid, sid);
                Map map = this.deliveredMessages;
                synchronized (map) {
                    this.deliveredMessages.put(entry, entry);
                }
            }
        }
        this.protocol.sendMessage(ref, cons, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumers(ConnectionUID uid) throws BrokerException {
        if (BrokerConsumers.getDEBUG()) {
            this.logger.log(8, "BrokerConsumers.removeConsumers for remote connection: " + (Object)((Object)uid));
        }
        HashSet<ConsumerUID> removedConsumers = new HashSet<ConsumerUID>();
        ConsumerUID cuid2 = null;
        Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>> map = this.consumers;
        synchronized (map) {
            for (ConsumerUID cuid2 : this.consumers.keySet()) {
                if (!uid.equals((Object)cuid2.getConnectionUID())) continue;
                removedConsumers.add(cuid2);
            }
        }
        map = this.pendingConsumerUIDs;
        synchronized (map) {
            for (ConsumerUID cuid2 : this.pendingConsumerUIDs.keySet()) {
                if (!uid.equals((Object)cuid2.getConnectionUID())) continue;
                removedConsumers.add(cuid2);
            }
        }
        for (ConsumerUID cuid2 : removedConsumers) {
            this.removeConsumer(cuid2, true);
        }
    }

    public void removeConsumer(ConsumerUID uid, boolean cleanup) throws BrokerException {
        this.removeConsumer(uid, null, cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID uid, Map<TransactionUID, LinkedHashMap<SysMessageID, Integer>> pendingMsgs, boolean cleanup) throws BrokerException {
        Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>> cparentmp;
        if (BrokerConsumers.getDEBUG()) {
            this.logger.log(8, "BrokerConsumers.removeConsumer(" + uid + ", " + pendingMsgs + ", " + cleanup + ")");
        }
        Consumer c = null;
        Object object = this.removeConsumerLock;
        synchronized (object) {
            c = (Consumer)this.consumers.remove(uid);
        }
        if (c == null && !cleanup) {
            return;
        }
        Destination d = null;
        if (c != null) {
            c.pause("MultiBroker - removing consumer");
            Destination[] ds = DestinationList.getDestination(null, c.getDestinationUID());
            d = ds[0];
            Object listener = this.listeners.remove(uid);
            if (listener != null) {
                c.removeEventListener(listener);
            }
            this.activeConsumers.remove(c);
        }
        LinkedHashSet<PacketReference> destroySet = new LinkedHashSet<PacketReference>();
        LinkedHashSet<AckEntry> openacks = new LinkedHashSet<AckEntry>();
        LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>> openmsgmp = new LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>>();
        LinkedHashMap<TransactionUID, LinkedHashSet<AckEntry>> mypending = new LinkedHashMap<TransactionUID, LinkedHashSet<AckEntry>>();
        boolean haspendingtxn = false;
        Map map = this.deliveredMessages;
        synchronized (map) {
            PacketReference ref;
            Map.Entry<TransactionUID, LinkedHashMap<SysMessageID, Integer>> pair;
            if (c != null) {
                this.cleanupList.put(uid, c.getParentList());
            }
            cparentmp = (Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>>)this.cleanupList.get(uid);
            if (BrokerConsumers.getDEBUG()) {
                this.logger.log(8, "BrokerConsumers.removeConsumer:" + uid + ", pending=" + pendingMsgs + ", cleanup=" + cleanup + ", cparentmp=" + cparentmp);
            }
            Iterator<Object> itr = this.deliveredMessages.values().iterator();
            while (itr.hasNext()) {
                AckEntry e = (AckEntry)itr.next();
                if (!e.getConsumerUID().equals(uid)) continue;
                if (pendingMsgs != null) {
                    Iterator<Map.Entry<TransactionUID, LinkedHashMap<Object, Integer>>> itr1 = pendingMsgs.entrySet().iterator();
                    pair = null;
                    TransactionUID tid = null;
                    LinkedHashMap<SysMessageID, Integer> sysiddcts = null;
                    Object mysysids = null;
                    LinkedHashSet<AckEntry> ackentries = null;
                    boolean found = false;
                    Integer deliverCnt = null;
                    while (itr1.hasNext()) {
                        pair = itr1.next();
                        tid = pair.getKey();
                        sysiddcts = pair.getValue();
                        deliverCnt = sysiddcts.get(e.getSysMessageID());
                        if (deliverCnt == null) continue;
                        if (tid != null && tid.longValue() == 0L) {
                            this.updateConsumed(e, deliverCnt, false);
                            continue;
                        }
                        if (cleanup || e.getTUID() != null) {
                            this.updateConsumed(e, deliverCnt, false);
                            break;
                        }
                        found = true;
                        ackentries = (LinkedHashSet<AckEntry>)mypending.get(tid);
                        if (ackentries == null) {
                            ackentries = new LinkedHashSet<AckEntry>();
                            mypending.put(tid, ackentries);
                        }
                        if (tid != null && !haspendingtxn) {
                            haspendingtxn = true;
                        }
                        ackentries.add(e);
                        this.updateConsumed(e, deliverCnt, false);
                        break;
                    }
                    if (found) continue;
                }
                if (e.getTUID() != null) continue;
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(4, "BrokerConsumers.removeConsumer:" + uid + ", remove AckEntry=" + e + ", c=" + c);
                }
                itr.remove();
                if (cleanup) {
                    this.updateConsumed(e, 1, true);
                }
                if (c != null) {
                    if (c.isFalconRemote()) {
                        e.acknowledged(false);
                        continue;
                    }
                    ref = e.getReference();
                    if (ref == null) continue;
                    ref.removeInDelivery(e.getStoredConsumerUID());
                    destroySet.add(ref);
                    continue;
                }
                ref = e.getReference();
                if (ref != null) {
                    ref.removeInDelivery(e.getStoredConsumerUID());
                }
                openacks.add(e);
            }
            for (AckEntry e : openacks) {
                if (cparentmp == null || cparentmp.size() == 0) {
                    e.acknowledged(false);
                    continue;
                }
                ref = e.getReference();
                if (ref == null) continue;
                PartitionedStore ps = null;
                ps = !ref.getDestinationUID().isQueue() ? new NoPersistPartitionedStoreImpl(e.getStoredConsumerUID()) : ref.getPartitionedStore();
                LinkedHashSet<PacketReference> set = (LinkedHashSet<PacketReference>)openmsgmp.get(ps);
                if (set == null) {
                    set = new LinkedHashSet<PacketReference>();
                    openmsgmp.put(ps, set);
                }
                set.add(ref);
            }
            if (cparentmp != null && cparentmp.size() > 0 && openmsgmp.size() > 0) {
                itr = openmsgmp.entrySet().iterator();
                PartitionedStore ps = null;
                Prioritized pl = null;
                pair = null;
                while (itr.hasNext()) {
                    pair = (Map.Entry<TransactionUID, LinkedHashMap<SysMessageID, Integer>>)itr.next();
                    ps = (PartitionedStore)pair.getKey();
                    pl = (Prioritized)cparentmp.get(ps);
                    if (pl != null) {
                        pl.addAllOrdered((Collection)((Set)((Object)pair.getValue())));
                        continue;
                    }
                    this.logger.log(16, "Message(s) " + cparentmp.get(ps) + "[" + ps + "] parentlist not found on removing consumer " + uid);
                }
            }
            if (cleanup || pendingMsgs == null) {
                this.cleanupList.remove(uid);
                this.pendingConsumerUIDs.remove(uid);
            } else if (mypending.size() > 0) {
                this.pendingConsumerUIDs.put(uid, mypending);
            }
        }
        if (c != null) {
            c.destroyConsumer(destroySet, false, false);
            if (d != null) {
                d.removeConsumer(uid, false);
            }
        }
        ArrayList l = null;
        cparentmp = this.pendingConsumerUIDs;
        synchronized (cparentmp) {
            l = new ArrayList(mypending.values());
        }
        Set entries2 = null;
        for (Set entries2 : l) {
            AckEntry entry2 = null;
            for (AckEntry entry2 : entries2) {
                entry2.pendingStarted();
            }
        }
        if (haspendingtxn) {
            this.notifyPendingCheckTimer();
        }
    }

    private void updateConsumed(AckEntry e, Integer deliverCnt, boolean cleanup) {
        PacketReference pr;
        int cnt = deliverCnt;
        if (cnt <= 0) {
            cnt = 1;
        }
        if ((pr = e.getReference()) != null && !e.hasMarkConsumed()) {
            ConsumerUID cuid = e.getConsumerUID();
            ConsumerUID suid = e.getStoredConsumerUID();
            try {
                pr.updateForJMSXDeliveryCount(suid, cnt, !cleanup);
                e.markConsumed();
            }
            catch (Exception ex) {
                Object[] args = new Object[]{"[" + pr + "," + suid + "]", cuid, ex.getMessage()};
                this.logger.log(16, Globals.getBrokerResources().getKString("B2244", args) + (cleanup ? "[RC]" : "[R]"), (Throwable)ex);
            }
        }
    }

    private void cleanupPendingConsumerUID(ConsumerUID cuid, SysMessageID sysid) {
        assert (Thread.holdsLock(this.deliveredMessages));
        Map<TransactionUID, Set<AckEntry>> pending = this.pendingConsumerUIDs.get(cuid);
        if (pending == null) {
            return;
        }
        Set<AckEntry> entries = null;
        Iterator<Map.Entry<TransactionUID, Set<AckEntry>>> itr = pending.entrySet().iterator();
        Map.Entry<TransactionUID, Set<AckEntry>> pair = null;
        while (itr.hasNext()) {
            pair = itr.next();
            entries = pair.getValue();
            if (!entries.remove(new AckEntry(sysid, cuid, null))) continue;
            if (entries.isEmpty()) {
                itr.remove();
                if (pending.isEmpty()) {
                    this.pendingConsumerUIDs.remove(cuid);
                    this.cleanupList.remove(cuid);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AckEntry> getPendingConsumerUID(TransactionUID tid) {
        assert (Thread.holdsLock(this.deliveredMessages));
        LinkedHashSet<Map<TransactionUID, Set<AckEntry>>> maps = null;
        Map<ConsumerUID, Map<TransactionUID, Set<AckEntry>>> map = this.pendingConsumerUIDs;
        synchronized (map) {
            maps = new LinkedHashSet<Map<TransactionUID, Set<AckEntry>>>(this.pendingConsumerUIDs.values());
        }
        Object var3_4 = null;
        for (Map map2 : maps) {
            if (map2 == null) continue;
            TransactionUID mytid = null;
            Object entries = null;
            Map.Entry pair22 = null;
            for (Map.Entry pair22 : map2.entrySet()) {
                mytid = (TransactionUID)pair22.getKey();
                if (mytid == null || !mytid.equals(tid)) continue;
                return new ArrayList<AckEntry>((Collection)pair22.getValue());
            }
        }
        return new ArrayList<AckEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean acknowledgeMessageFromRemote(int ackType, SysMessageID sysid, ConsumerUID cuid, Map optionalProps) throws BrokerException {
        boolean entry3;
        if (ackType == 0) {
            Consumer c = Consumer.getConsumer(cuid);
            if (c == null) return true;
            if (optionalProps == null) {
                c.resumeFlow();
                return true;
            }
            Integer pref = (Integer)optionalProps.get("prefetch");
            if (pref == null) {
                c.resumeFlow();
                return true;
            }
            int prefetch = Consumer.calcPrefetch(c, pref);
            if (prefetch <= 0 || prefetch > BTOBFLOW) {
                prefetch = BTOBFLOW;
            }
            c.resumeFlow(prefetch);
            return true;
        }
        if (ackType == 5) {
            String tid = null;
            String tidi = null;
            String tido = null;
            String tida = null;
            if (optionalProps != null && ((tidi = (String)optionalProps.get("RB_RELEASE_MSG_INACTIVE")) != null || (tido = (String)optionalProps.get("RB_RELEASE_MSG_ORPHAN")) != null || (tida = (String)optionalProps.get("RB_RELEASE_MSG_ACTIVE")) != null || optionalProps.get("RC_RELEASE_MSG_INACTIVE") != null)) {
                tid = tidi == null ? (tido == null ? tida : tido) : tidi;
                String logstrop = " for rollback remote transaction " + tid;
                String logstrtyp = "";
                if (tidi == null && tido == null && tida == null) {
                    logstrop = " CLIENT_ACKNOWLEDGE recover";
                } else {
                    String string = tidi == null ? (tido == null ? "active" : "orphaned") : (logstrtyp = "inactive");
                }
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Releasing message [" + sysid + ", " + cuid + "](" + logstrtyp + ")" + logstrop);
                }
                AckEntry entry2 = new AckEntry(sysid, cuid, null);
                AckEntry value2 = null;
                Consumer tidac = null;
                Map map = this.deliveredMessages;
                // MONITORENTER : map
                if (tida != null) {
                    value2 = (AckEntry)this.deliveredMessages.get(entry2);
                    if (value2 != null && ((tidac = (Consumer)this.consumers.get(value2.getConsumerUID())) == null || value2.isPendingStarted() || value2.getTUID() == null || !value2.getTUID().toString().equals(tida))) {
                        value2 = null;
                    }
                    if (value2 != null) {
                        value2 = (AckEntry)this.deliveredMessages.remove(entry2);
                    }
                } else {
                    value2 = (AckEntry)this.deliveredMessages.remove(entry2);
                    this.cleanupPendingConsumerUID(cuid, sysid);
                }
                // MONITOREXIT : map
                if (value2 == null) {
                    if (!BrokerConsumers.getDEBUG()) return true;
                    this.logger.log(8, "Releasing message [" + sysid + ", " + cuid + "](" + logstrtyp + ")" + logstrop + ": entry not found");
                    return true;
                }
                PacketReference ref = value2.getReference();
                if (ref == null) {
                    if (!BrokerConsumers.getDEBUG()) return true;
                    this.logger.log(8, "Releasing message [" + value2 + "](" + logstrtyp + ") ref null" + logstrop);
                    return true;
                }
                if (tidac != null) {
                    Object[] args = new Object[]{sysid, tid, tidac.toString()};
                    this.logger.log(8, this.br.getKString("B1516", args));
                    ArrayList<PacketReference> list = new ArrayList<PacketReference>();
                    list.add(ref);
                    tidac.routeMessages(list, true);
                    return true;
                }
                ConsumerUID sid = value2.getStoredConsumerUID();
                ConsumerUID uid = value2.getConsumerUID();
                if (sid != null && sid != uid) {
                    ref.removeInDelivery(value2.getStoredConsumerUID());
                    ref.getDestination().forwardOrphanMessage(ref, value2.getStoredConsumerUID());
                    return true;
                }
                try {
                    if (!ref.acknowledged(uid, sid, !uid.isDupsOK(), false)) return true;
                    Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                    Destination d = ds[0];
                    d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    return true;
                }
                catch (Exception e) {
                    this.logger.logStack(16, "Unable to cleanup message " + ref.getSysMessageID() + logstrop, (Throwable)e);
                }
                return true;
            }
            if (optionalProps != null && optionalProps.get("MSG_NOT_SENT_TO_REMOTE") != null && ((String)optionalProps.get("MSG_NOT_SENT_TO_REMOTE")).equals("true")) {
                AckEntry entry3 = new AckEntry(sysid, cuid, null);
                AckEntry value = null;
                Map entry2 = this.deliveredMessages;
                // MONITORENTER : entry2
                value = (AckEntry)this.deliveredMessages.get(entry3);
                // MONITOREXIT : entry2
                if (value == null) {
                    return true;
                }
                PacketReference ref = value.getReference();
                if (ref != null && !ref.isDestroyed()) {
                    if (!ref.isInvalid()) return true;
                }
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Cleanup dead message (not remote delivered): " + value);
                }
                Map value2 = this.deliveredMessages;
                // MONITORENTER : value2
                this.deliveredMessages.remove(entry3);
                // MONITOREXIT : value2
                return true;
            }
            if (!BrokerConsumers.getDEBUG()) return true;
            this.logger.log(4, "got message ignored ack, can not process [" + sysid + "," + cuid + "]" + ackType);
            return true;
        }
        AckEntry entry4 = new AckEntry(sysid, cuid, null);
        AckEntry value = null;
        if (ackType == 1) {
            Map map = this.deliveredMessages;
            // MONITORENTER : map
            value = (AckEntry)this.deliveredMessages.remove(entry4);
            this.cleanupPendingConsumerUID(cuid, sysid);
            // MONITOREXIT : map
            if (value != null) return value.acknowledged(false);
            return true;
        }
        Map map = this.deliveredMessages;
        // MONITORENTER : map
        value = (AckEntry)this.deliveredMessages.remove(entry4);
        this.cleanupPendingConsumerUID(cuid, sysid);
        if (ackType != 7 && ackType != 6) {
            this.logger.log(32, "Internal Error: ackMessageFromRemote: unexpetected ackType:" + ackType);
            // MONITOREXIT : map
            return false;
        }
        boolean deliveredack = false;
        if (optionalProps != null) {
            deliveredack = optionalProps.get("MSG_DELIVERED_ACK") != null;
        }
        try {
            if (value != null && value.getTUID() != null) {
                this.logger.log(16, "Ignore mark message dead " + sysid + " for it's prepared with TUID= " + value.getTUID());
                entry3 = false;
                return entry3;
            }
            if (value == null && !cuid.equals(PacketReference.getQueueUID())) {
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Mark dead message: entry not found:" + sysid + "," + cuid);
                }
                boolean entry3 = false;
                return entry3;
            }
            if (BrokerConsumers.getDEBUG()) {
                Globals.getLogger().log(8, "Dead message " + sysid + " notification from  " + cuid.getBrokerAddress() + " for remote consumer " + cuid);
            }
            if (value != null) {
                PacketReference ref = value.getReference();
                if (ref == null) {
                    ref = DestinationList.get(null, sysid);
                }
                if (ref != null) {
                    ref.removeInDelivery(value.getStoredConsumerUID());
                    this.removeRemoteDeadMessage(ackType, ref, cuid, value.getStoredConsumerUID(), optionalProps);
                }
            } else if (cuid.equals(PacketReference.getQueueUID())) {
                Iterator itr = this.deliveredMessages.values().iterator();
                int i = 0;
                while (itr.hasNext()) {
                    AckEntry e = (AckEntry)itr.next();
                    if (e.getTUID() != null || !e.getConsumerUID().getBrokerAddress().equals(cuid.getBrokerAddress()) || !e.getSysMessageID().equals((Object)sysid)) continue;
                    ConsumerUID sid = e.getStoredConsumerUID();
                    ConsumerUID uid = e.getConsumerUID();
                    PacketReference ref = e.getReference();
                    if (ref == null) {
                        ref = DestinationList.get(null, sysid);
                    }
                    if (ref != null) {
                        ref.removeInDelivery(e.getStoredConsumerUID());
                        this.removeRemoteDeadMessage(ackType, ref, uid, sid, optionalProps);
                    }
                    if (BrokerConsumers.getDEBUG()) {
                        this.logger.log(8, "Cleanup remote dead ack entries(" + i++ + "th): " + e);
                    }
                    itr.remove();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Consumer c;
            if (!deliveredack || (c = Consumer.getConsumer(cuid)) == null) {
                // MONITOREXIT : map
                return entry3;
            }
            c.resumeFlow(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRemoteDeadMessage(int ackType, PacketReference ref, ConsumerUID cuid, ConsumerUID storedid, Map optionalProps) throws BrokerException {
        if (ref == null) {
            return true;
        }
        Destination d = ref.getDestination();
        Queue[] qs = DestinationList.getDMQ(ref.getPartitionedStore());
        if (d == qs[0]) {
            return true;
        }
        String comment = null;
        Object reason = null;
        Exception ex = null;
        Integer deliverCnt = null;
        Integer reasonInt = null;
        String deadbkr = null;
        if (optionalProps != null) {
            comment = (String)optionalProps.get("JMS_SUN_DMQ_UNDELIVERED_COMMENT");
            ex = (Exception)optionalProps.get("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION");
            deliverCnt = (Integer)optionalProps.get("JMQ_SUN_JMSQ_TempRedeliverCnt");
            reasonInt = (Integer)optionalProps.get("REASON");
            deadbkr = (String)optionalProps.get("JMS_SUN_DMQ_DEAD_BROKER");
        }
        RemoveReason rr = null;
        if (ackType == 6) {
            rr = RemoveReason.UNDELIVERABLE;
        } else {
            rr = RemoveReason.ERROR;
            if (reasonInt != null) {
                rr = RemoveReason.findReason(reasonInt);
            }
        }
        if (comment == null) {
            comment = "none";
        }
        if (ref.markDead(cuid, storedid, comment, ex, rr, deliverCnt == null ? 0 : deliverCnt, deadbkr)) {
            try {
                if (ref.isDead()) {
                    if (BrokerConsumers.getDEBUG()) {
                        Globals.getLogger().log(8, "Remove dead message " + ref + " for remote consumer " + cuid + " on destination " + d + " with reason " + (Object)((Object)rr));
                    }
                    try {
                        d.removeDeadMessage(ref);
                    }
                    catch (Exception e) {
                        this.logger.log(16, "Unable to remove dead[" + (Object)((Object)rr) + ", " + deadbkr + "] message " + ref + "[" + cuid + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                ref.postAcknowledgedRemoval();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMessageFromRemote2P(int ackType, SysMessageID[] sysids, ConsumerUID[] cuids, Map optionalProps, Long txnID, BrokerAddress txnHomeBroker) throws BrokerException {
        if (txnID == null) {
            throw new BrokerException("Internal Error: call with null txnID");
        }
        TransactionUID tid = new TransactionUID(txnID);
        if (ackType == 8) {
            PartitionedStore refpstore = null;
            TransactionAcknowledgement ta = null;
            ArrayList<TransactionAcknowledgement> tltas = null;
            TransactionAcknowledgement[] tas = null;
            HashMap<TransactionList, ArrayList<TransactionAcknowledgement>> tltasmap = new HashMap<TransactionList, ArrayList<TransactionAcknowledgement>>();
            TransactionList tl2 = null;
            AckEntry entry = null;
            AckEntry value = null;
            StringBuffer dbuf = new StringBuffer();
            AckEntryNotFoundException ae = null;
            Map map = this.deliveredMessages;
            synchronized (map) {
                for (int i = 0; i < sysids.length; ++i) {
                    TransactionList[] tls;
                    String emsg;
                    entry = new AckEntry(sysids[i], cuids[i], null);
                    value = (AckEntry)this.deliveredMessages.get(entry);
                    if (value == null) {
                        emsg = "[" + sysids[i] + ":" + cuids[i] + "]TID=" + tid + " not found, maybe rerouted";
                        if (ae == null) {
                            ae = new AckEntryNotFoundException(emsg);
                        }
                        ae.addAckEntry(sysids[i], cuids[i]);
                        this.logger.log(16, "[" + sysids[i] + ":" + cuids[i] + "] not found for preparing remote transaction " + tid + ", maybe rerouted");
                        continue;
                    }
                    if (value.getTUID() != null) {
                        emsg = "[" + sysids[i] + ":" + cuids[i] + "]TID=" + tid + "  has been rerouted";
                        if (ae == null) {
                            ae = new AckEntryNotFoundException(emsg);
                        }
                        ae.addAckEntry(sysids[i], cuids[i]);
                        this.logger.log(16, "[" + sysids[i] + ":" + cuids[i] + "] for preparing remote transaction " + tid + " conflict with transaction " + value.getTUID());
                        continue;
                    }
                    PacketReference ref = value.getReference();
                    if (ref == null) {
                        this.deliveredMessages.remove(entry);
                        String emsg2 = "Unable to prepare [" + sysids[i] + ":" + cuids[i] + "]TID=" + tid + " because the message has been removed";
                        if (ae == null) {
                            ae = new AckEntryNotFoundException(emsg2);
                        }
                        ae.addAckEntry(sysids[i], cuids[i]);
                        this.logger.log(16, emsg2);
                        continue;
                    }
                    ConsumerUID scuid = value.getStoredConsumerUID();
                    ta = new TransactionAcknowledgement(sysids[i], cuids[i], scuid);
                    if (!scuid.shouldStore() || !ref.isPersistent()) {
                        ta.setShouldStore(false);
                    }
                    Globals.getDestinationList();
                    if (!DestinationList.isPartitionMode()) {
                        tls = DestinationList.getTransactionList(Globals.getStore().getPrimaryPartition());
                        tl2 = tls[0];
                    } else {
                        refpstore = ref.getPartitionedStore();
                        Globals.getDestinationList();
                        tls = DestinationList.getTransactionList(refpstore);
                        tl2 = tls[0];
                        if (tl2 == null) {
                            this.deliveredMessages.remove(entry);
                            String emsg3 = "Unable to prepare [" + sysids[i] + ":" + cuids[i] + "]TID=" + tid + " because transaction list for partition " + refpstore + " not found";
                            if (ae == null) {
                                ae = new AckEntryNotFoundException(emsg3);
                            }
                            ae.addAckEntry(sysids[i], cuids[i]);
                            this.logger.log(16, emsg3);
                            continue;
                        }
                    }
                    tltas = (ArrayList)tltasmap.get(tl2);
                    if (tltas == null) {
                        tltas = new ArrayList<TransactionAcknowledgement>();
                        tltasmap.put(tl2, tltas);
                    }
                    tltas.add(ta);
                    if (!BrokerConsumers.getDEBUG()) continue;
                    dbuf.append("\n\t[" + ta + "]" + tl2);
                }
                if (ae != null) {
                    throw ae;
                }
                Iterator itr = tltasmap.entrySet().iterator();
                Map.Entry pair = null;
                while (itr.hasNext()) {
                    pair = itr.next();
                    tl2 = (TransactionList)pair.getKey();
                    tltas = (ArrayList<TransactionAcknowledgement>)pair.getValue();
                    tas = tltas.toArray(new TransactionAcknowledgement[tltas.size()]);
                    TransactionState ts = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ts.setState(5);
                    if (BrokerConsumers.getDEBUG()) {
                        this.logger.log(8, "Preparing remote transaction " + tid + " for [" + tltas + "]" + tl2 + " from " + txnHomeBroker);
                    }
                    tl2.logRemoteTransaction(tid, ts, tas, txnHomeBroker, false, true, true);
                }
                for (int i2 = 0; i2 < sysids.length; ++i2) {
                    entry = new AckEntry(sysids[i2], cuids[i2], null);
                    value = (AckEntry)this.deliveredMessages.get(entry);
                    value.setTUID(tid);
                }
            }
            for (TransactionList tl2 : tltasmap.keySet()) {
                tl2.pendingStartedForRemotePreparedTransaction(tid);
            }
            this.notifyPendingCheckTimer();
            if (BrokerConsumers.getDEBUG()) {
                this.logger.log(8, "Prepared remote transaction " + tid + " from " + txnHomeBroker + dbuf.toString());
            }
            return;
        }
        if (ackType == 9) {
            List<Object[]> list;
            if (BrokerConsumers.getDEBUG()) {
                this.logger.log(8, "Rolling back remote transaction " + tid + " from " + txnHomeBroker);
            }
            if ((list = TransactionList.getTransListsAndRemoteTranStates(tid)) == null) {
                if (BrokerConsumers.getDEBUG()) {
                    this.logger.log(8, "Rolling back non-prepared remote transaction " + tid + " from " + txnHomeBroker);
                }
                List<AckEntry> entries = null;
                Map tltas = this.deliveredMessages;
                synchronized (tltas) {
                    entries = this.getPendingConsumerUID(tid);
                    Iterator<AckEntry> itr = entries.iterator();
                    AckEntry e = null;
                    while (itr.hasNext()) {
                        e = itr.next();
                        if (this.deliveredMessages.get(e) == null) {
                            itr.remove();
                            continue;
                        }
                        if (this.consumers.get(e.getConsumerUID()) == null) continue;
                        itr.remove();
                    }
                    if (e != null) {
                        this.deliveredMessages.remove(e);
                        this.cleanupPendingConsumerUID(e.getConsumerUID(), e.getSysMessageID());
                    }
                }
                if (entries.size() == 0) {
                    this.logger.log(8, this.br.getKString("B1445", tid, txnHomeBroker));
                    return;
                }
                for (AckEntry e : entries) {
                    PacketReference ref;
                    SysMessageID sysid = e.getSysMessageID();
                    ConsumerUID cuid = e.getConsumerUID();
                    ConsumerUID suid = e.getStoredConsumerUID();
                    if (suid == null) {
                        suid = cuid;
                    }
                    if ((ref = DestinationList.get(null, sysid)) == null) {
                        if (!BrokerConsumers.getDEBUG()) continue;
                        this.logger.log(8, "[" + sysid + ":" + cuid + "] reference not found in rolling back remote non-prepared transaction " + tid);
                        continue;
                    }
                    ref.removeInDelivery(suid);
                    ref.getDestination().forwardOrphanMessage(ref, suid);
                }
                return;
            }
            TransactionList tl = null;
            Object[] oo = null;
            for (int li = 0; li < list.size(); ++li) {
                RemoteTransactionAckEntry tae;
                oo = list.get(li);
                tl = (TransactionList)oo[0];
                if (!tl.updateRemoteTransactionState(tid, 7, false, false, true)) {
                    return;
                }
                if (tl.getRecoveryRemoteTransactionAcks(tid) != null) {
                    this.rollbackRecoveryRemoteTransaction(tl, tid, txnHomeBroker);
                }
                if ((tae = tl.getRemoteTransactionAcks(tid)) == null) {
                    this.logger.log(8, Globals.getBrokerResources().getKString("B1309", tid));
                } else if (tae.processed()) {
                    this.logger.log(8, Globals.getBrokerResources().getKString("B1310", tid));
                } else if (!tae.isLocalRemote()) {
                    TransactionAcknowledgement[] tas = tae.getAcks();
                    LinkedHashSet<TransactionAcknowledgement> s = new LinkedHashSet<TransactionAcknowledgement>();
                    AckEntry entry = null;
                    AckEntry value = null;
                    for (int i = 0; i < tas.length; ++i) {
                        SysMessageID sysid = tas[i].getSysMessageID();
                        ConsumerUID uid = tas[i].getConsumerUID();
                        ConsumerUID suid = tas[i].getStoredConsumerUID();
                        if (suid == null) {
                            suid = uid;
                        }
                        Map i2 = this.deliveredMessages;
                        synchronized (i2) {
                            entry = new AckEntry(sysid, uid, null);
                            value = (AckEntry)this.deliveredMessages.get(entry);
                            if (value == null) {
                                if (BrokerConsumers.getDEBUG()) {
                                    this.logger.log(8, "[" + sysid + ":" + uid + "] not found in rolling back remote transaction " + tid);
                                }
                                continue;
                            }
                            if (value.getTUID() == null || !value.getTUID().equals(tid)) {
                                if (BrokerConsumers.getDEBUG()) {
                                    this.logger.log(8, "[" + sysid + ":" + uid + "] with TUID=" + value.getTUID() + ", in confict for rolling back remote transaction " + tid);
                                }
                                continue;
                            }
                            if (this.consumers.get(uid) == null) {
                                this.deliveredMessages.remove(entry);
                                this.cleanupPendingConsumerUID(uid, sysid);
                                s.add(tas[i]);
                            } else {
                                value.setTUID(null);
                            }
                            continue;
                        }
                    }
                    for (TransactionAcknowledgement ta : s) {
                        PacketReference ref;
                        SysMessageID sysid = ta.getSysMessageID();
                        ConsumerUID cuid = ta.getConsumerUID();
                        ConsumerUID suid = ta.getStoredConsumerUID();
                        if (suid == null) {
                            suid = cuid;
                        }
                        if ((ref = DestinationList.get(null, sysid)) == null) {
                            if (!BrokerConsumers.getDEBUG()) continue;
                            this.logger.log(8, "[" + sysid + ":" + cuid + "] reference not found in rolling back remote transaction " + tid);
                            continue;
                        }
                        ref.removeInDelivery(suid);
                        ref.getDestination().forwardOrphanMessage(ref, suid);
                    }
                }
                try {
                    tl.removeRemoteTransactionAck(tid);
                }
                catch (Exception e) {
                    this.logger.log(16, "Unable to remove transaction ack for rolledback transaction " + tid + ": " + e.getMessage());
                }
                try {
                    tl.removeRemoteTransactionID(tid, true);
                    continue;
                }
                catch (Exception e) {
                    this.logger.log(16, "Unable to remove rolledback remote transaction " + tid + ": " + e.getMessage());
                }
            }
            return;
        }
        int cLogRecordCount = 0;
        ArrayList<String> cLogDstList = null;
        ArrayList<SysMessageID> cLogMsgList = null;
        ArrayList<ConsumerUID> cLogIntList = null;
        if (ackType == 1) {
            List<Object[]> list;
            if (BrokerConsumers.getDEBUG()) {
                this.logger.log(8, "Committing remote transaction " + tid + " from " + txnHomeBroker);
            }
            if ((list = TransactionList.getTransListsAndRemoteTranStates(tid)) == null) {
                throw new BrokerException("Committing remote transaction " + tid + " not found", 404);
            }
            TransactionList tl = null;
            Object[] oo = null;
            for (int li = 0; li < list.size(); ++li) {
                RemoteTransactionAckEntry tae;
                oo = list.get(li);
                tl = (TransactionList)oo[0];
                if (!tl.updateRemoteTransactionState(tid, 6, sysids == null, true, true)) {
                    if (!BrokerConsumers.getDEBUG()) continue;
                    this.logger.log(8, "Remote transaction " + tid + " already committed, from " + txnHomeBroker);
                    continue;
                }
                boolean done = true;
                if (tl.getRecoveryRemoteTransactionAcks(tid) != null) {
                    done = this.commitRecoveryRemoteTransaction(tl, tid, txnHomeBroker);
                }
                if ((tae = tl.getRemoteTransactionAcks(tid)) == null) {
                    this.logger.log(8, "No non-recovery transaction acks to process for committing remote transaction " + tid);
                } else if (tae.processed()) {
                    this.logger.log(8, "No more transaction acks to process for committing remote transaction " + tid);
                } else if (!tae.isLocalRemote()) {
                    boolean found = false;
                    TransactionAcknowledgement[] tas = tae.getAcks();
                    for (int i = 0; i < tas.length; ++i) {
                        SysMessageID sysid = tas[i].getSysMessageID();
                        ConsumerUID cuid = tas[i].getConsumerUID();
                        if (sysids != null && !found && sysid.equals((Object)sysids[0]) && cuid.equals(cuids[0])) {
                            found = true;
                        }
                        String dstName = null;
                        if (Globals.txnLogEnabled()) {
                            PacketReference ref;
                            if (cLogDstList == null) {
                                cLogDstList = new ArrayList<String>();
                                cLogMsgList = new ArrayList<SysMessageID>();
                                cLogIntList = new ArrayList<ConsumerUID>();
                            }
                            if ((ref = DestinationList.get(null, sysid)) != null && !ref.isDestroyed() && !ref.isInvalid()) {
                                Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                                Destination dst = ds[0];
                                dstName = dst.getUniqueName();
                            }
                        }
                        if (this.acknowledgeMessageFromRemote(ackType, sysid, cuid, optionalProps)) {
                            if (dstName == null) continue;
                            ConsumerUID suid = tas[i].getStoredConsumerUID();
                            if (suid == null) {
                                suid = cuid;
                            }
                            ++cLogRecordCount;
                            cLogDstList.add(dstName);
                            cLogMsgList.add(sysid);
                            cLogIntList.add(suid);
                            continue;
                        }
                        done = false;
                    }
                    if (Globals.isNewTxnLogEnabled()) {
                        BrokerConsumers brokerConsumers = this;
                        if (brokerConsumers.DL.isPartitionMode()) {
                            throw new BrokerException("Partition mode not supported if newTxnLog enabled");
                        }
                        ((TxnLoggingStore)((Object)Globals.getStore().getPrimaryPartition())).loggedCommitWrittenToMessageStore(tid, 2);
                    }
                    if (sysids != null && !found) {
                        this.logger.log(32, "Internal Error: [" + sysids[0] + ":" + cuids[0] + "] not found in remote transaction " + tid);
                        done = false;
                    }
                }
                if (done) {
                    try {
                        tl.removeRemoteTransactionAck(tid);
                    }
                    catch (Exception e) {
                        this.logger.logStack(16, "Unable to remove transaction ack for committed remote transaction " + tid, (Throwable)e);
                    }
                    try {
                        tl.removeRemoteTransactionID(tid, true);
                    }
                    catch (Exception e) {
                        this.logger.logStack(16, "Unable to remove committed remote transaction " + tid, (Throwable)e);
                    }
                    continue;
                }
                if (!Globals.getHAEnabled()) continue;
                throw new BrokerException("Remote transaction processing incomplete, TUID=" + tid);
            }
            try {
                if (Globals.txnLogEnabled() && cLogRecordCount > 0) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(cLogRecordCount * 72 + 12);
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeLong(tid.longValue());
                    dos.writeInt(cLogRecordCount);
                    for (int i = 0; i < cLogRecordCount; ++i) {
                        String dst = (String)cLogDstList.get(i);
                        dos.writeUTF(dst);
                        SysMessageID sysid = (SysMessageID)cLogMsgList.get(i);
                        sysid.writeID((DataOutput)dos);
                        long intid = ((ConsumerUID)cLogIntList.get(i)).longValue();
                        dos.writeLong(intid);
                    }
                    dos.close();
                    bos.close();
                    ((TxnLoggingStore)((Object)Globals.getStore().getPrimaryPartition())).logTxn(2, bos.toByteArray());
                }
            }
            catch (IOException ex) {
                Globals.getBrokerResources();
                this.logger.logStack(32, "B3100", (Object)"Got exception while writing to transaction log", (Throwable)ex);
                throw new BrokerException("Internal Error: Got exception while writing to transaction log", ex);
            }
            return;
        }
        throw new BrokerException("acknowledgeMessageFromRemotePriv:Unexpected ack type:" + ackType);
    }

    private void rollbackRecoveryRemoteTransaction(TransactionList translist, TransactionUID tid, BrokerAddress from) throws BrokerException {
        RemoteTransactionAckEntry[] tae;
        BrokerAddress currba;
        this.logger.log(8, "Rolling back recovery remote transaction " + tid + " from " + from);
        TransactionState ts = translist.getRemoteTransactionState(tid);
        if (ts == null || ts.getState() != 7) {
            Globals.getBrokerResources();
            throw new BrokerException("B3100", "Unexpected broker state " + ts + " for processing Rolledback remote transaction " + tid);
        }
        TransactionBroker ba = translist.getRemoteTransactionHomeBroker(tid);
        BrokerAddress brokerAddress = currba = ba == null ? null : ba.getCurrentBrokerAddress();
        if (currba == null || !currba.equals(from)) {
            this.logger.log(16, "Rolledback remote transaction " + tid + " home broker " + ba + " not " + from);
        }
        if ((tae = translist.getRecoveryRemoteTransactionAcks(tid)) == null) {
            this.logger.log(16, "No recovery transaction acks to process for rolling back remote transaction " + tid);
            return;
        }
        for (int j = 0; j < tae.length; ++j) {
            if (tae[j].processed()) continue;
            TransactionAcknowledgement[] tas = tae[j].getAcks();
            for (int i = 0; i < tas.length; ++i) {
                PacketReference ref;
                SysMessageID sysid = tas[i].getSysMessageID();
                ConsumerUID cuid = tas[i].getConsumerUID();
                ConsumerUID suid = tas[i].getStoredConsumerUID();
                if (suid == null) {
                    suid = cuid;
                }
                if ((ref = DestinationList.get(null, sysid)) == null) {
                    if (!BrokerConsumers.getDEBUG()) continue;
                    this.logger.log(8, "[" + sysid + ":" + cuid + "] reference not found in rolling back recovery remote transaction " + tid);
                    continue;
                }
                ref.getDestination().forwardOrphanMessage(ref, suid);
            }
        }
    }

    private boolean commitRecoveryRemoteTransaction(TransactionList translist, TransactionUID tid, BrokerAddress from) throws BrokerException {
        RemoteTransactionAckEntry[] tae;
        BrokerAddress currba;
        this.logger.log(8, "Committing recovery remote transaction " + tid + " from " + from);
        TransactionBroker ba = translist.getRemoteTransactionHomeBroker(tid);
        BrokerAddress brokerAddress = currba = ba == null ? null : ba.getCurrentBrokerAddress();
        if (currba == null || !currba.equals(from)) {
            this.logger.log(16, "Committed remote transaction " + tid + " home broker " + ba + " not " + from);
        }
        if ((tae = translist.getRecoveryRemoteTransactionAcks(tid)) == null) {
            this.logger.log(16, "No recovery transaction acks to process for committing remote transaction " + tid);
            return true;
        }
        boolean done = true;
        for (int j = 0; j < tae.length; ++j) {
            if (tae[j].processed()) continue;
            TransactionAcknowledgement[] tas = tae[j].getAcks();
            for (int i = 0; i < tas.length; ++i) {
                PacketReference ref;
                SysMessageID sysid = tas[i].getSysMessageID();
                ConsumerUID uid = tas[i].getConsumerUID();
                ConsumerUID suid = tas[i].getStoredConsumerUID();
                if (suid == null) {
                    suid = uid;
                }
                if ((ref = DestinationList.get(null, sysid)) == null || ref.isDestroyed() || ref.isInvalid()) continue;
                try {
                    if (!ref.acknowledged(uid, suid, true, true)) continue;
                    ref.getDestination().removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    continue;
                }
                catch (Exception ex) {
                    done = false;
                    Globals.getBrokerResources();
                    this.logger.logStack(32, "B3100", (Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Consumer c) throws BrokerException {
        block39: {
            ConsumerUID cuid;
            if (BrokerConsumers.getDEBUG()) {
                this.logger.log(8, "BrokerConsumers.addConsumer: " + c);
            }
            if (this.consumers.get(cuid = c.getConsumerUID()) != null) {
                String emsg = Globals.getBrokerResources().getKString("B1331", cuid, c.getDestinationUID());
                this.logger.log(8, emsg + " (CLUSTER_ROUTER)");
                throw new ConsumerAlreadyAddedException(emsg);
            }
            DestinationList.acquirePartitionLock(true);
            try {
                DestinationUID duid;
                if (!(c instanceof Subscription)) {
                    this.consumers.put(cuid, c);
                    this.pendingConsumerUIDs.put(cuid, null);
                    this.listeners.put(cuid, c.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
                }
                int type = (duid = c.getDestinationUID()).isQueue() ? 1 : 2;
                Destination d = null;
                try {
                    if (duid.isWildcard()) {
                        d = null;
                    } else {
                        for (int i = 0; i < 2; ++i) {
                            Destination[] ds = DestinationList.getDestination(Globals.getStore().getPrimaryPartition(), duid.getName(), type, true, true);
                            d = ds[0];
                            try {
                                if (d == null) continue;
                                d.incrementRefCount();
                                break;
                            }
                            catch (BrokerException ex) {
                                d = null;
                            }
                        }
                        if (d == null) {
                            throw new BrokerException("Unable to attach to destination " + duid);
                        }
                    }
                }
                catch (IOException ex) {
                    throw new BrokerException("Unable to autocreate destination " + duid, ex);
                }
                try {
                    if (!c.getDestinationUID().isQueue() && !(c instanceof Subscription) && c.getSubscription() == null) {
                        c.setFalconRemote(true);
                    } else {
                        Subscription sub;
                        int prefetch;
                        int mp;
                        int n = mp = d == null ? -1 : d.getMaxPrefetch();
                        if (mp <= 0 || mp > BTOBFLOW) {
                            mp = BTOBFLOW;
                        }
                        if ((prefetch = c.getRemotePrefetch()) <= 0 || prefetch > mp) {
                            prefetch = mp;
                        }
                        if ((sub = c.getSubscription()) != null && sub.getShared()) {
                            prefetch = 1;
                        }
                        c.setPrefetch(prefetch);
                    }
                    try {
                        Destination dd2;
                        if (d == null && c.getSubscription() == null) {
                            Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, c.getDestinationUID());
                            LinkedHashSet<Destination> dset2 = null;
                            dd2 = null;
                            for (LinkedHashSet<Destination> dset2 : dmap.values()) {
                                if (dset2 == null) continue;
                                for (Destination dd2 : dset2) {
                                    if (dd2 == null) continue;
                                    try {
                                        dd2.addConsumer(c, false);
                                    }
                                    catch (ConsumerAlreadyAddedException e) {
                                        this.logger.log(8, e.getMessage() + " (CLUSTER_ROUTER)");
                                    }
                                }
                            }
                        } else if (c.getSubscription() == null) {
                            Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, c.getDestinationUID());
                            LinkedHashSet<Destination> dset3 = null;
                            dd2 = null;
                            for (LinkedHashSet<Destination> dset3 : dmap.values()) {
                                if (dset3 == null) continue;
                                for (Destination dd2 : dset3) {
                                    if (dd2 == null) continue;
                                    try {
                                        dd2.addConsumer(c, false);
                                    }
                                    catch (ConsumerAlreadyAddedException e) {
                                        this.logger.log(8, e.getMessage() + " (CLUSTER_ROUTER)");
                                    }
                                }
                            }
                        }
                    }
                    catch (SelectorFormatException ex) {
                        throw new BrokerException("unable to add destination " + d, ex);
                    }
                    if (c instanceof Subscription || !c.isBusy()) break block39;
                    Set set = this.activeConsumers;
                    synchronized (set) {
                        this.activeConsumers.add(c);
                        this.activeConsumers.notifyAll();
                    }
                }
                finally {
                    if (d != null) {
                        d.decrementRefCount();
                    }
                }
            }
            finally {
                DestinationList.releasePartitionLock(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.valid) {
            Consumer c = null;
            Set set = this.activeConsumers;
            synchronized (set) {
                while (this.valid && this.activeConsumers.isEmpty()) {
                    try {
                        this.activeConsumers.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.valid) {
                    Iterator itr = this.activeConsumers.iterator();
                    c = (Consumer)itr.next();
                    itr.remove();
                    if (c.isBusy()) {
                        this.activeConsumers.add(c);
                    }
                }
            }
            if (c == null) continue;
            PacketReference ref = null;
            HashSet<Consumer> s = null;
            boolean cb = false;
            Object object = this.removeConsumerLock;
            synchronized (object) {
                if (this.consumers.get(c.getConsumerUID()) == null) {
                    if (BrokerConsumers.getDEBUG()) {
                        Globals.getLogger().log(8, "BrokerConsumers.run(): ignore removed consumer: " + c);
                    }
                    continue;
                }
                ref = (PacketReference)c.getAndFillNextPacket(null);
                if (ref == null) {
                    continue;
                }
                s = new HashSet<Consumer>();
                s.add(c);
                boolean bl = cb = ref.getMessageDeliveredAck(c.getConsumerUID()) || c.isPaused();
                if (!c.getConsumerUID().isNoAck()) {
                    AckEntry entry = new AckEntry(ref, c.getConsumerUID(), c.getStoredConsumerUID());
                    Map map = this.deliveredMessages;
                    synchronized (map) {
                        this.deliveredMessages.put(entry, entry);
                        if (BrokerConsumers.getDEBUG()) {
                            this.logger.log(4, "deliveredMessages:" + entry);
                        }
                    }
                }
            }
            this.protocol.sendMessage(ref, s, cb);
        }
    }

    class AckEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        WeakReference pref = null;
        SysMessageID id = null;
        BrokerAddress address = null;
        TransactionUID tuid = null;
        long pendingStartTime = 0L;
        boolean markConsumed = false;

        public AckEntry(SysMessageID id, ConsumerUID uid, BrokerAddress address) {
            assert (id != null);
            assert (uid != null);
            this.id = id;
            this.uid = uid;
            this.address = address;
            this.pref = null;
        }

        public void markConsumed() {
            this.markConsumed = true;
        }

        public boolean hasMarkConsumed() {
            return this.markConsumed;
        }

        public String toString() {
            return "" + this.id + "[" + this.uid + ", " + this.storedcid + "]TUID=" + this.tuid + ", (" + this.pendingStartTime + ")";
        }

        public void pendingStarted() {
            this.pendingStartTime = System.currentTimeMillis();
        }

        public boolean isPendingStarted() {
            return this.pendingStartTime != 0L;
        }

        public boolean isPendingTimeout(long timeout) {
            return System.currentTimeMillis() - this.pendingStartTime >= timeout;
        }

        public void setTUID(TransactionUID uid) {
            this.tuid = uid;
        }

        public TransactionUID getTUID() {
            return this.tuid;
        }

        public BrokerAddress getBrokerAddress() {
            return this.address;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public ConsumerUID getStoredConsumerUID() {
            return this.storedcid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            return (PacketReference)this.pref.get();
        }

        public AckEntry(PacketReference ref, ConsumerUID uid, ConsumerUID storedUID) {
            this.pref = new WeakReference<PacketReference>(ref);
            this.id = ref.getSysMessageID();
            this.storedcid = storedUID;
            this.uid = uid;
        }

        public boolean acknowledged(boolean notify) {
            assert (this.pref != null);
            PacketReference ref = (PacketReference)this.pref.get();
            boolean done = true;
            try {
                if (ref == null) {
                    DestinationList cfr_ignored_0 = BrokerConsumers.this.DL;
                    ref = DestinationList.get(null, this.id);
                }
                if (ref == null) {
                    return true;
                }
                if (ref.acknowledged(this.uid, this.storedcid, !this.uid.isDupsOK(), notify, this.tuid, null, null, true)) {
                    if (this.tuid != null && ((BrokerConsumers)BrokerConsumers.this).fi.FAULT_INJECTION) {
                        BrokerConsumers.this.fi.checkFaultAndExit("msg.remote_ack.home.c.txncommit.1_7", null, 2, false);
                    }
                    DestinationList cfr_ignored_1 = BrokerConsumers.this.DL;
                    Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                    Destination d = ds[0];
                    d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
            }
            catch (Exception ex) {
                BrokerConsumers.this.logger.logStack(16, "Unable to process acknowledgement:[" + this.id + "," + this.uid + "]", (Throwable)ex);
                done = false;
            }
            return done;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AckEntry)) {
                return false;
            }
            AckEntry ak = (AckEntry)o;
            return this.uid.equals(ak.uid) && this.id.equals((Object)ak.id);
        }

        public int hashCode() {
            return this.id.hashCode() * 15 + this.uid.hashCode();
        }
    }

    private class PendingCheckEventHandler
    implements TimerEventHandler {
        public void handleOOMError(Throwable e) {
            Logger cfr_ignored_0 = BrokerConsumers.this.logger;
            BrokerConsumers.this.logger.logStack(16, "OutOfMemoryError[ClusterRouterPendingTransactionTimer]", e);
        }

        public void handleLogInfo(String msg) {
            Logger cfr_ignored_0 = BrokerConsumers.this.logger;
            BrokerConsumers.this.logger.log(8, msg + "[ClusterRouterPendingTransactionTimer]");
        }

        public void handleLogWarn(String msg, Throwable e) {
            Logger cfr_ignored_0 = BrokerConsumers.this.logger;
            BrokerConsumers.this.logger.logStack(16, msg + "[ClusterRouterPendingTransactionTimer]", e);
        }

        public void handleLogError(String msg, Throwable e) {
            Logger cfr_ignored_0 = BrokerConsumers.this.logger;
            BrokerConsumers.this.logger.logStack(16, msg + "[ClusterRouterPendingTransactionTimer]", e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimerExit(Throwable e) {
            Object object = BrokerConsumers.this.pendingCheckTimerLock;
            synchronized (object) {
                BrokerConsumers.this.pendingCheckTimer = null;
            }
            if (BrokerConsumers.this.valid) {
                Logger cfr_ignored_0 = BrokerConsumers.this.logger;
                BrokerResources cfr_ignored_1 = BrokerConsumers.this.br;
                BrokerConsumers.this.logger.log(16, BrokerConsumers.this.br.getKString("B1473"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long runTask() {
            LinkedHashSet maps = null;
            Map map = BrokerConsumers.this.pendingConsumerUIDs;
            synchronized (map) {
                maps = new LinkedHashSet(BrokerConsumers.this.pendingConsumerUIDs.values());
            }
            Map map22 = null;
            for (Map map22 : maps) {
                if (map22 == null) continue;
                TransactionUID tid = null;
                Set entries = null;
                Map.Entry pair2 = null;
                for (Map.Entry pair2 : map22.entrySet()) {
                    tid = (TransactionUID)pair2.getKey();
                    if (tid == null) continue;
                    entries = (Set)pair2.getValue();
                    AckEntry entry2 = null;
                    for (AckEntry entry2 : entries) {
                        if (!entry2.isPendingTimeout((long)pendingCheckInterval * 1000L)) continue;
                        BrokerConsumers.this.protocol.sendTransactionInquiry(tid, entry2.getConsumerUID().getBrokerAddress());
                    }
                }
            }
            Globals.getDestinationList();
            TransactionList[] tls = DestinationList.getTransactionList(null);
            TransactionList tl = null;
            ArrayList tids = null;
            Object tid = null;
            for (int i = 0; i < tls.length; ++i) {
                tl = tls[i];
                if (tl == null || (tids = tl.getPreparedRemoteTransactions((long)pendingCheckInterval * 1000L)) == null || tids.size() == 0) continue;
                BrokerConsumers.this.protocol.sendPreparedTransactionInquiries(tids, null);
            }
            return 0L;
        }
    }
}

